(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    134168,       2118]*)
(*NotebookOutlinePosition[    144603,       2465]*)
(*  CellTagsIndexPosition[    144382,       2455]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"Top",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{0, 8}, {0, 8}},
  FontFamily->"Helvetica",
  Background->GrayLevel[0],
  CellTags->"Top"],

Cell[TextData[ValueBox["$ExpirationString"]], "TopMatter",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontWeight->"Bold",
  FontColor->RGBColor[0.0154879, 0.897581, 0.88574],
  CellTags->"Top"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005V0000`A000`40O003h00Ooe@5Ie@5001RE0D0
1F04E0ED1E@5H0@0oe@5000ZE0D00dP;D4aEC002B4`3E:`00eg>E:a82`0EB0/2D4`2E:`00dDX>8Lh
Q`02>8L01BR7C8IPZ6DWE:`01F2X00e<QTQ<D4a<QSR7B4a41db6>8M<QV2XE:aPZ002E:`4H:P2C8H0
0eQRE0EHHP02F680262XF69<QU@5H:QD1FDWMJL6IBL00eB/E0ED1@3NE0D002X0000630LHJCF]<H`]
Jc6<0bU;00dTba0850PD21@950PD2A@850TD21@950PD2@0250P011@950PD21@90Q@80Q@90QQY00<T
baSW2<D00Q240PS500T<H`S55:DXj2DY=BLXQcDW:>P00SDW00/HJBR7:4<HaQ@85:DX@`S57>8X`adY
008Xj008>8LXQbR7:8LX@acR?0048@DX@`057>8X@aS6<D<X``07<D<2<H?P000002X0000330LHJBC;
008@R@079</@R@`734PHJA@950P00Q@90Q@800@D2A@850PD2@8D200?50TD21@950PD2A@850TD21@9
50PD2AQY9</Hia2400<8a@0636<8a@S536<8iBSX0RR700@PjBR7=BLXj0<X@`0?66T@Q12448@<1bQ3
;DLe9bSX8>TXj3R7:>PX@acR00HX@`077>848BQ336<X@bS3;DL01C5300@aPc53<H<X`n000000:P00
00<<1aQY34P00Q0800HPjA@940P@212950T350P02A@950PD2A@850TD21@950PD2@0250P011@950PD
21@90Q@800HD2AQY66TTbaSW2<D348@00`S536<8a@0236<030@Q5:DYBbSX;DLQ22R75:DXQaBU66T<
B08<1`062<D@Q3537B@@jQ290bSX0RQ30P@Q00PX@b81<D<X@bR78@PXQa240RS300@X@c53<D<aP`Ha
@n000000:P0000<D21QY40P00Q0800HTb`a840P@RAQY50P250T05a@850TD21@950PD2A@850TD21@9
50PD2A@850TD21@950PD2A@850THJBC;7>L00`S500<<H`S548@00PS500l<H`S5:4<Xj2e[=BLXj2R7
8@PTba296<H8i`a82<D00Q2400/a@adY7BTPjCDW:8LX@acR:4<l01cR00<m8006:<<DYBSX:>PHaRR7
0RQ300LX`c53<D<aPc53<H<a@`025:GP000002X0000630LPRa3Z30L<B23Y0QQY00<TbaQY50P00Q@8
00PD2A@850PD2A@850TD21@90Q@800@D2A@850PD2@8D200350TD21@9008HJ@0388/Li`S500@@Q005
2<D@Q0S52<D<H`02:4<042SX=BLXj3R7:>PTb`C;2>L@R@CZ2>L<1`aS7B@Libe70RDY00DHJBQ3:<<L
hP@Q008X``8LhP0;8P4XQbSX6<HX`bDY<D<X@bS3<D<aP`04<D<00aQY30`0003O000002X0000<30LT
bbe[:D/aSC6<;F/aSC6<40PD2A@80Q@900LD21@950PD2A@850TD200250T03A@850TD21@950PD2A@8
50TD21@966TTbacW008@Q0042<D@Q0S548@22<D01PaS2<D<H`@Q:4<HaP8Pj@0A9</Xj0C;1>X4b`CZ
34P@R@S67>8M92e77@PIJb3Y:4<DY@03:4<03353?B0LhQcR48@X`aS6:8LLibR7>6<m80@a@`04<H<a
@a@830cP000002X0000330LPjBU;008Pj@064>XHJA29:D/@21@90a@800@D2A@850PD2@8D200650TD
21@850TD21@90Q@800@D2A@850PD2@8HJ@049</Hia242<D348@00`S536<8a@022<D01Q2430L<HbR7
6F/Tb`8@jP0B1</8i`U:1>X8ia2934P8aAdT;DLM:B3Y9BTX@bS336<LhRS30acR00Pm80@Q124X@bR7
:<<HaRSX1C5300@aPbS330`<3>000000:P0000@<1b2;48T<B0<@200434PHJA@950P250T02Q@850TD
21@950PD2A@850TD21@90Q@800HD2A@850TD21@950P250T01QQY9</Li`S548@8a@<@Q0032<D<H`S5
008@Q0075:D@Q2Q3:>PU:B3Y4>X00PC;00T91`CZ1</4jPa82>LLhRe77BT00RDY00DX`bQ3124X@acR
008m808LhP09:8L<H`@Q36<X@aS6:8Le9be700<a@`04<H<a@bS366WP000002X0000330LHJ@a800@@
200434PHJA0850T250P011@950PD21@90Q@800dD2A@850PD2A@850TD21@950PD2A@850TD200266T0
2RC;7>LDaA242<D<Ha242<D@Q0aS0PS500P@Q2Q336<<1b3Y=BL@RAQY0PC;00l4jPC;1</8i`CZ48T@
Q2fT7BTU:BSX:4<X`acR:4<01AcR0RR700LHaRQ336<<HbQ37>8a@`02;DL2<D<2<H<00c530000003N
000002X0000<50PPRb3Y66T@RB3Y9</YBbC;40PD2A@80Q@900XD21@950PD2A@850TD21@950PD2@8D
200550TD21@850TD200250T00aQY88/Li`0248@00`aS2<D8a@0248@32<D010aS:4<@Q1240RR7018@
RA3Z1</1KPC;48TDYA292>L4b`SW3B@M:Be79BT@Q0aS:4<27>803CdP7>8a@acR5:DLibSX8>TDYBQ3
36<X`c53008LhP03<D<aPc63008aPiH00003?0048BQ300848A000004124X@`@Q124A00000c`0124X
@`0M000002X0000330LHJC6<008aS007<Hd]JbU;:D/@21@850T00Q@800DD2A@850TD21@9008D200;
50TD21@850TD21@950PD2A@850TD200266T012C;7>LDa@S50PaS0Q2410S500<@Q0aS2<D00PaS00<H
aR3Y1</00PC;00<DYBQ3:4<00RQ300/<B0SW48@HaRDY7BTM90aS:4<LhSdP00<LhP03:4<PjBSX008H
i`03:8LX`be7008a@`05?B0a@c53<H<a@`02:<>A00001BQ3B05P0F01H0@01G0100AP0EQR?0048@X0
0003?01P0G01009`0@03H0580@@Q00X00005124l05@5H05P1004L0401601B04X@`@Q6000000Z0000
0``766TTb`0248T01B3Y30L<B23Y50T00Q@80Q@90Q@800`D2A@850PD2A@850TD21@950PD2A@850T2
50P350T02QQY9</LiaC548@8a@aS48@8a@aS1`S500X<Ha294>X@jPC;6<HX`cR7:4<X``8X@`0848@D
YA246>LIJbR736<X@`8LhP05?B0LhPaS:4<DY@02:8L2:>P01BR766TDYB48;DL00S5300@aPc5366T<
38h00004124l0701L043N0400g01N05h0@02N0401g01N05h0GP1L05P0BQ300H00005125P0GP1N05`
0@02N0401701N05P0C`01`0000@48C`0N05`0@9h0@07L05h0GP1L05h0G01N0400W0100<l00000000
5@00000Z00002@`788/Pj@`734PYBa2930LPj@0250T350P02A@950PD2A@850TD21@950PD2@0250P0
0a@950PD200250T250P266T0122;7>LDa@S50PaS00<8aA242<D020S500T8ia3Z0FhDYBQ3>6<X@bS3
>8L00bQ300dDYA2436<HaR487>8<HbQ3:<<LhRQ348@X@`0336<022Q366TXj2487BT8aQ29:>P2<H<0
0c5348@D2@2=000032Q3H05h0G01N05`0GP1L05h0G01N05`0@9h0@9`0@Ah0@03B0448@0000<00003
B05h0G0100=h0@03L05h0GP1009`0@H00003:4=P0GP1009h0@04L05h0GP1L042N0400g01N05h0@02
N0400g01H04X@`0E000002X0000530LHJB3Y40PPj@02:D/011089</<B1@80a@900@D21@950PD2@8D
200950TD21@950PD2A@850TD21@9008D208D2@0466TPRad85<D236<01@S536<8a@S52<H010S500d8
aPS52<D8aBSX1</X`cQS:<<X@cQS:4<hH`03:4<05@aS:4<<HacR36<l012436<X@``736<DYAS66>LD
Y@aS5:D@Q0SW66TLi`0236<01C53<H<aPbR730`0S00000<l0701L0400WP100=`0GP1N0400gP100A`
0GP1N05`0@=h0@06L05h0G01N05P0@@Q0`0000I`0GP1N05`0GP1L042N0401701N05`0BQ3100000Hl
0701N05`0GP1L042N0401701N05h0G010WP100=`0GP1L0400WP100=`0BQ300004`00000Z00001@`7
66TTb`a850T00Pa800<@jRU;48T011@800XD2A@850PD2A@850TD21@950PD2@8D200650TD21@850TD
21@90QQY00@TbacW5<D@Q0<<H`0348@8a@S600P8a@0:4>XDYCQS:4<hHbS3A0LX@cQS:<<2:4<236<0
0bQ37>8<H`02:4<01QBU48@8aPS536<XQ`<Xj00<48@<H`aS5:D<HbQ336<@Q2S3<H<M90a8R`0000<X
@gP1L0400WP100I`0GP1N05`0GP1L042N0401W01N05h0G01N05`0@9h0@04L05h0GP1H04200000c`0
N05`0@02N0400g01N05`0@04N0401DP100000000?0000W010WP100=`0GP1L0400WP100E`0GP1N05h
0G01009h0@06L05h0G01N05`0BQ34`00000Z00001P`750PaS23Y34P@208D2@0<66T@21@950TD21@9
50PD2A@850TD21@90Q@801DD2A@850TD21@950PD2A@850TD21@966TTbacW5<D8a@aS2<D<Ha242<D0
0PS610S50108aPS52<D4jPaS>6<X@cR7:<<X@cDW:4<hHbQ336<@Q08<H`04:4<LhQcR:4<248@236<0
0a246<HPj@028>T02RR7:>PDaA2450P<HbQ336<X@adT0QcRRP0000D48F01N05h0G01009h0@06L05h
0GP1L05h0G010WP100I`0GP1N05`0GP1L042N0402G01N05h0DP100048G01N05`0@04N0401G01N05`
0GP1B0400`0000AP0GP1N05`0@Ah0@03L05h0GP1009`0@9h0@03L05h0GP1009h0@03L05h0F0101<0
0000:P000Q@800<@jQQY34P00a0800<<B1@950T00Q@800@D2A@850PD2@8D200350TD21@9008D2007
50TD21@850TD21@950P00Q@900@HJBC;7>L@Q0@<H`042<D@Q0S62<H22<D02PS62<D8a@S62>D8aPaS
>6<X@bS30PaS0RQ300LhHbR748@<HacR:4<<H`02:4<010@Q36<<H`aS0aBU00@PjB488>T@R@8Pj@07
6<HHi`S648@<H`S530L00RQ3RP0000Hl0701N05`0GP1L043N0401701N05h0GP10W0100=h0G01N040
0gP100I`0GP1N05h0G01H04200002F01N05h0GP1L05h0G01N05`0@02N043000014P1O0Ah0G010WP1
00=`0GP1L0400WP100U`0GP1N05h0G01N05`0GP1L0400WP100=`0GP1B0404P00000Z00001@`766TY
Ba2966T00Q2901D@223Y50TD21@950PD2A@850TD21@950PD2A@850TD21@950PD2A@850T00Q@800XD
2A@866THJBC;6<H@Q0dT36<8a@8<H`062<D8aPS62<H8a@S60PS500T8aPSU2<D@Q3QS:<<@Q0aS:4<0
0Q240bQ300T<HbQ3124LhPaS124@Q1BU7>800PaS00DLhP@Q:4<<HbR7008Pj@0766T@RAd88>T8i`a8
2>D00`aSRP0000=P0GP1L0400gP100=`0GP1L0400WP100E`0DP1?00l0701009h0@03L05h0G01009h
0@9`0@06N05`0BQ3000l06010W0100=h0G01N0400gP100A80@00000l00=`0@9h0@03L05h0G01009h
0@05L05h0GP1N05`0@03N0401701N05h0G010WP100=`0@@Q00004000000Z00002P`766TaS23Y7BTT
bb3Y9</aS1080Q@800PD2A@850PD2A@850TD21@90Q@800hD2A@850TD21@950PD2A@850TD21QY88/P
jAS60Q240PaS00D8a@aS48@8a@SW00<8aP88a@052<H8i@S636<hH`022>D010@Q5:DHJ@aS0bQ300D@
Q0aS:4<X@acR00H@Q00A7>8X@`0036<@Q1296>LU:AdY6>LPRaSW36<X@`aS48T8i`2900003BQ3L05`
0GP1L05h0G01N05`0GP1L05h0C`000<00007125P0GP1N05`0GP1L04017P100I`0C`0000003`0L043
N0401701N05h0C`00`0000E80GP1N05h0G01009h0@0>L05h0GP1L05h0G01B05`0GP1L05h0G01N05`
0@9h0@04L05h0G01?00A000002X0000330LHJAQY008<B00588/]Jc6<4>X@200250T01Q@850TD21@9
50PD2@8D200450TD21@850T250P02a@950PD21@950PD2A@888/U:AC548@01@aS00<8aA2448@00`SW
1@S600LLhRQ32@L8aQ2436<DY@0236<011cR:4<@Q2Q30PaS00PLhQBU48@@Q0`77>8DaA240QcW00T8
a@aS30L8a@SU:8LLib3Y9BT00Q2400<<1a@9>0`0RP002WP100=P0@0000000`0000<l0701N0400gP1
00I`0GP1L05h0G01?00400001C`0B05P0F01B040100000<48G01L0400gP100A`0GP1N05`0@9h0@05
?000000000180@03N0400g01N05`0@02N0400g01N05`0@0A000002X0000950PD2A0834PPjC6<9</@
RA08008D2@8D200650TD21@950PD2A@80Q@900PD21@950PD2A@850TD21@90Q@800LD2AQY88/PjAC5
48@=900236<01@S536<<H`S536<00Q240PSW10S60QBU00d8i@T72>D48BQ336<X@c53:4<<H`@Q:4<L
hP0336<27>800a2430L<H`026>L021QY4>XDYA2436<48BQ336<234P010dT34PD2B2;R@0000`l04P1
H0580F01B05P0DP1H0580F01?005000023`0L05h0G01N05`0GP1L043N0400c`00000000<0002N040
1G01N05`0GP1L0400gP100=80@0000000`0000=80GP1L0400gP100=`0GP1N0400W0100<48@000000
3P00000Z000020`750PPjBe[:D/@R@`740P350T01A@850TD21@850T00Q@800dD2A@850PD21@950PD
2A@850TD21@950PD2@0266T00b2;8>THaP0248@010aS2>D<H`aS0PS50PaS0QBU10SW0`S600<91`SU
2<H00PaS00L@Q0aS:4<@Q0aS7>8X@`0348@47>802QBU:4<HiaS65:DQ223Y:>PXQaSW0PS500H<Ha24
34P@Q0a850VJ00001EQRN05`0GP1L04017P10W013P0000E80G01N05h0G0100=h0@04L05h0G011245
00001S`0L05h0G01N05`0@9h0@04L05h0GP1?00@000002X0008D200A4>XYBbC;4>X@R@a840PD2A@8
50TD21@950PD2A@850TD200250T021@850TD21@850TD21@950P350T011QY88/PjAS60Q240`aS00D8
a@@Q2<D@Q1BU00848@0836<8aPSW2>L8aPSW2<H8i@891`0348@<HaBU008X@`05124<HbQ37>8@Q002
36<37>8020@Q36<DYA298>T@jRSX:8L26>L00bC;7BTDY@0236<011@82<D8i`CZU`000P@Q00A80G01
N05`0@=h0@05L05h0G01N05P0@0>00000dP1N05`0@02N0401W01N05`0GP1L05P0@L00006H05h0GP1
L05h0G010WP100=`0GP1B0404000000R0002124600001@`750P@20`740P00b3Y00@@RA@950PD2@8D
20<D2@0:50PD2A@850PD2A@850TD21@950P550T266T00bC;7>L@Q00248@236<248@010aS2<D48BQ3
0PaS00@48@S62>L8i`@8aP88i@0336<48@aS008@Q005:4<<H`aS2<D<H`037>8010aS:4<<Ha240PaS
00`X@aS67>LM20dT5:DHJASW:4<<Ha242>L22>DH0002125>00000`@Q36<@Q0025:D00a2412448@0V
00001C`0N05`0GP1L0400WP100=`0GP1L0400WP100=`0GP100003P0000EHHWP1L05h0G01009h0@04
L05h0G01B04700000dP1N05`0@03N0401G01N05h0G01B0404000000A000011cWDYA>Ldic0TYB00E6
<DYBCW=BU24800H00003BU9BU00000D0000:>E5Nn5[gDYA:Me:DEYMNmeKFDS@4EYL3DS@2EYL00e8d
66TD2@0250P011@9AO=FUe[F158d00eBU5JGG_PmkacWE]IF]E:DCW=BLeJeDW=>L`02DY@02UJG6F/8
a@aS2<H8ic8`F_MFeUJe0U:D00=>Le9cCW<00UJe00E>LRQ334P@Q3g_009F]@03CW=BLe9c009>L`06
E[EBU5:D@Q0<HcG`0U[F00QF]E[FE[EBU4icDYAFeU:D0Tic00A:DTicBU9>L`9:DP05;F/002e[E[E>
L`03BU8014icDYA:DP@Q100000<48F<H8@P0100000@48E:DDYA>L`A:DP05AS5>Le:DE[EBU003BU80
14icDYAF]BDY100000@@Q5JeCW=>L`=:DP07AS5:DU:DDY@@Q1BUE[D00Tic1TYB00=>Le:D48@01@00
00<YBe:DCW<01TYB00A>Le:D@Q048@@00004124e[E[FLg`2Ool2Mkd026mKF]I242DY36<002U;DY@2
BU801DXaBU9>Le:D=Jd0100000@<HdYBDYA>L`E:DP03CW=BU2DY00T00003B05`0GP1009h0@03L05h
0G0100=h0@9`0@03:4<0000000d00003H05h0GP1009h0@06L05h0GP1N05`0C`01`0000=80G01N040
0W010WP100A`0GP1N05P0A0000004@0000<LifmKMkd01Goo0WNm00<aS0000000100000=S67oo8@P0
1@0000=5lgNmMkd027oo00=g_FmKMkd00goo0VmK00ANn1QY50TD208D2@03AO=_Fg=l00Ioo`06Lga5
lbe[HaQ_FgNm1Woo00YcO6lj=BL@Q0S62<D<B3F_Ke]cO0Ioo`03Mke_Fekg008@Q00436=9cW=lOkX6
Ool01GNmLgaBU0S5<Hd00W=l1Woo17=l00Ag_G=lLgag_@9oo`05MkdDYBDYHaQ_F`03Ool017NmJeYF
]@@Q100000<DYGooE[D0100000@48EJeJeY_F`Eoo`04MkeS66<HHaP3Ool017NmJeYS62e[100000@<
HekgJeYg_@Eoo`07MkeS61S648AS66mKMkd01Woo00=_Ff]J5:D01@0000<U:F]JKe/01Woo00Ag_FmK
DY@48@<0000:7>MS67ooOomg_Dic;F/U:C6<DY@3Ool016]J?NlYBf<H17oo0V]J00<mk`0000000P00
00@48E:DJeYcO0Eoo`03Mke[FRe[00T00005?01h0G01N05`0@04N042L0400dP1?000000?00002g01
N05`0GP1L05h0G01N05`0GP1?0001`0000=80GP1N0400gP100E`0GP1N05h0F01010000004P0000T4
8@aS36=F]GooMkdU:@aS12401P0000D48G=lOomJeP@Q00@0000530LPRc6=<He>=004Ool02dhd88/P
Rb2;9<]S67ooAO<PRaQY40P00Q@800LD2A@850PD2B2;66U>=003Ool016mK98dTbbe[0c6<00<YBcg_
Ool00Woo00=cO2DY5:D00RQ30Pa80PS500D8ia3Z4>XIJeKF00=oo`06E[DDYABU:4<<Ha240PaS00@D
YA24:8M[FP=oo`04BS4PjBU;8>T26<H2:4<00a5XJeYoo`02Ool013G@88/TS@aS0P@Q00P<H`@Q124Q
26mKOomF]@000P@Q00@]JgooMkdDY@848@D000049BUoogoo8BP4000312401RDYOomoogooJeX<H`<4
8@048@Qg_G=l5:D21246000212400a24Lgaoo`02Ool00d8@12448@02000312401SW>OomoogooJeX@
Q0848@L000848@0336=F]Goo009oo`04CW<<H`@Q124300001R4XMkeoogooG_L@Q0D000035:E>Lgoo
009oo`067>L48ABUKe]g_BU;0P@Q1P000P@Q00<<He[FOol00Woo00=BU0aS12402P0000A80G01N05`
0@9h0@06L05h0G01N05P0@@Q4@000W0100=h0G01N0400gP100=`0GP1?0001`0000Dl07P1L05h0G01
009h0@04L05h0G01H04@000001D000047>Mooflj124800001ABUMkeoogoo9BT0100000H<1aQY8>T<
1a29Leh3Ool00bB=50TD200266T02RB=Mke5la@9;F/PRa0850TD21@90a@800<D2DGcOol00Woo00A5
laQY66TYB`DaS007LgaoogooKcXDaA2436<00P@Q00P8i`S62<H8i`S62<D8ic6<0goo00U:M`S636<4
8A242<D<H`S62>L00PaS00i>4WooOomoocG`8>THi`S6:8LHaR488>T8ie9c0Woo00Ag_C6=50TPR`L0
00048@Qg_GNm7>L2000010@QHaQg_@@Q1`0000@e[GooOomS60P00004Ke]oogooG_L500000d8@OolD
Y@0:00001P@QKe]oogooMkd@Q0L00005125g_GooOomS600=00001Be[Oomoogoo?Nl01@0000H48FmK
OomoofmK36<8000013g_Oomoocg_0P0000<]Jgoo;F/02P0000H48E[FOomoogNm8@P<00001DP1N05`
0GP1L0400WP100=`0GP1N0400W0100<48@0000003P0000MP0GP1L05h0G01N05`0@03N0400dP10000
000500001U@5N05h0G01N05`0@9h0@03L05h0DP1010000005P0000=[FW=l5:D0200000DU:GNmOomo
oekg00@0000630LHJBU;34P@26<H0goo00Te[a@850TD21QY9<]Nn6mK9</00Re[00@@21@850PD20<D
2@0350QNn7oo009oo`0598dHJAQY;F/aS002;F/2<H`026]JOomoogNm;H/U:ASW36<22<D01`a82<H8
i`SW34P8aBU;00=oo`07G_P91`SW2<H<B0aS2<H00`SW00<<HcW>Ool00Woo00Y6<ASW7@PQ21cW:8L8
aPSW:>QB=0=oo`03=JlD21@900P00003<Haooe:D00<00003@Q1ooaS600L00005BU9oogooOolYB`07
00001EkgOomoof<H1240100000<@Q7NmAS402P0000HHaWNmOomoof<H124800001F<HOomoog=l1240
300000DLigNmOomoodic00D00005=JeoogooOolYB`0:00000dicOomNm`0200000`@QKe]JeP0:0000
1PaSJeYoogooKe/@Q0`00003?01P0G0100=h0@04L05h0GP1L042N0400f011240000>00001DP1N05h
0GP1L0400WP100A`0GP1L05P0@H00004125`0GP1L043N0401G01N05h0G01B0404000000F00000d8@
OolYB`0800000cW>Oomoo`02Ool02Re[0000000030LHJC6<9</PjEkh0goo00`iDA@950PD22C;:D/a
SGoo@Q0Tbbe[40P350T350P031QYLgaoogooLg`PRaQY88/]Jc6<;F/aS08]J`05G_MoogooMkdmk`02
<H`00be[9BTM20052>L00`S66F]cO002Ool00f]J1>X4jP022>L00`S52<H8a@022>L00`aS8>Uoo`02
Ool01E8d8@PHJB487@P00QSW00<Q22R7>Lh00goo00=>4RQ330L02@0000=6<Goo8@P00P0000<LigNm
=Jd01`0000IS67ooOomoof<H124600001DicOomoog=l12401@0000=:DWNm36<02@0000DaS7ooOomo
odic00T00005F]IoogooMkd@Q00<00001A24Ke]oogooF]H01@0000ES67ooOomS60@Q00X00004125N
mgNm5:D200000c6<OolLi`0900001AS6OomoogooHaP03`0000@l0601L05`0@9h0@06L05h0GP1L05h
0DP13`0000@l07P1N05`0@9h0@03L05h0GP1009h0@03:4<0000000<00003?01`0G01009h0@9`0@9h
0@03L05h0C`0010000005P0000<HaWooAS40200000=>LgooOol00Woo00Y[FP@Q000000`766TPjA29
9<]BU0=oo`03AO<D2A@8008D2007:D/PRf<HKe/Tbbe[40P00a@80Q@900<D22B=Mkd00Woo00IS61QY
66TPRbe[<H`4;F/01E:DOomoogooAS400Re[136<00LU:AdY6>L8i`S62>M[FP02Ool017=l2DX4jPSW
10S60`SW00PDYGNmOomooe[F6>LLiaQY0QBU00DXQacW6>LM:GNm009oo`03E]H8aPa800X00003?NlL
i`0000800003JeYBU00000D00007125cO7ooOomg_Goo=Jd01P0000E247ooOomg_@@Q00D0000348Ag
_Cg_00T00005BU9oogooOolaS00900001DYBOomoogoo8@P03@0000ES67ooOomS60aS00<000056<Ig
_GooOolmk`0<00000aBUMkdicP0200000`@QKe]>L`0900001Bf;OomoogooDW<00`0000TX@`00:4<4
8BQ3000X@`@Q?000100000=80GP1N0400W0100Ah0G01N05h0@9`0@l00003125h0GP1009h0@05L05h
0GP1L05h0@02L0401P@Q00000000:4=`0@9h0@03L05h0GP1009h0@03L05h0GP1014000005`0000=c
O5kg12401`0000MNmgooOomoofmKOole[@0200001P`750T<B10848U6<@=oo`05DS@D2A@950PD2@02
8>T01CUAOom6<B3Y50P00Q@911@800Ded7ooOomoodGc008HJ@0388/aS36<00@]J`05AS5oogooOom>
L`05;F/4<H`012U;8>TDYEkh0Woo00Eg_AU[1>X4jPa80088aP062>L8aPS62>LX@f<H0Woo00][FPT7
2>DDYB486<HHib3Y7@PYBg=l009oo`03HaP8i`SW00l00003BU9[FP0000D000046<IoogooOol2CW<0
0fmK36<0000400001CF]Oomoogoo5:D01P0000=BU6mK1240200000ENmgooOomoob4800T00005=Jeo
ogooOol]J`0=00001E:DOomoofmK48@00`0000DaS7ooOomoobDY00d00003;F/YB`0000800003>Lio
o`aS00P00005AS5oogooOole[@0200001701N05h0G0117P100=`0G`4B0400`0000<l0701N04017P1
00A`0GP1N05h0A000003H05h0G01009h0@04L05h0GP1L043N0400eQRB05P0@02N0401W01N05h0G01
N05`0@9h0@03L05P0@00010000005`0000=6<GNm5:D01P0000<@Q6mKOol00Woo00/aS5[FHaP48@00
50PD2A0834PYBdGc00=oo`0<G_PD21@850TTbbDY9</aS6mKIa`D21080a@80QQY00<PReJGOol00Woo
00DiDA@866TTbc6<00@]J`039BTe[GNm009oo`03E[D]Jbf;008]J`05<H`]Jbe[<H`]J`02<H`01Re[
E]IoogooMkdIKP88i`032<H8a@S600<8aP032>L8aUKF009oo`0;Lg`M21cW8@PXQa3Z2<D@Q2Q38@Q[
FP02Ool00flj:8L<B00400000be[<H`0000800000b48MkdHaP050000236<Oomoogoo=Jd@Q7Nm>Lh5
00001BDYOomoogoo9BT01P0000<HaWNm;F/01`0000H48F<HOomoofmK48@900001BDYOomoogoo?Nl0
3@0000E6<GooOomg_AS600<00005?NmoogooOolLi`0B00000`aSLg`mk`0800001E[FOomoogoo7>L0
0P0000MP0GP1L05h0G01N05`0@02N042L04013`0124X@f010WP100=`0GP1L0400WP100A`0GP1L044
8@l00004?01h0GP1L042N0402701N05h0G01N05`0GP1L042N0401W01N05`0G01N05`0@9h0@03L05h
0C`0014000005`0000<Ligoo<H`01P00010LigNmOomoogNm6<HDYGoo=Jd000`766T]JbU;8>TaS@=o
o`0=Ia`D2A@950PPjBC;40PHJCF_Oom5lbB=<Hd00SF_00@iDCF]=Jm_F`9oo`06MkdTSA@866TPRc6<
0be[0RDY00He[gNmOomooe[F:>P2;F/01c6<;F/]Jc6<;F/aS2e[008aS007DYAoogooOolel0dX2<D0
0`aS00H8a@S62<D8a@SWAU<2Ool01gNm>8LX@`SW6<HHJBQ3008<H`0834QF]GooOomg_BC;50T48@<0
0003G_MS600000T00003Ke/mk`0000@00009AS5oogooOolQ2000AS5cO0@Q00@000056<IoogooOola
S00700000e:DJeXQ20026<H01QcW6<HLiaS6;F]g_@9oo`03F]H0000000P000055:EoogooOom:DP0=
00001CW>Oomoogoo9BT00`0000E6<GooOomg_AcW01<00003?Nmg_BDY008HaP067>LHaQcW6<HQ27=l
0Woo00EcO0@Q0000060100Ah0@04L05h0GP1L043N0401f01L05h0GP1L05h0G01009h0@04L05h0G01
L04A0002L042N0401701N05h0G010gP100A`0GP1N05`0@Mh0@03L05h0F01018000005`0000<<HfmK
DY@01P00014]JgooOomoof]J48@005JeKe/<H``766TaS12934PTSGNm009oo`03Ke/HJA@800<D208H
J@039<]_Fgoo00Ag_@03Oomg_GNm00=oo`0=HaPPRaQY66TPjC6<;F/aS2DY>6<X@cDWKcX00Woo00=_
>SR7;F/00Re[00<aS2e[;F/00be[00<aS2e[AS400goo00I>Lbe[:D/U:ASW6<H22<H22<D00`S6>Lio
o`02Ool00cDW30L<H`0236<01A242<H<B0a8DS@00Woo00=g_C6=50T0100000=JeV<H12402@0000=>
Lekg0000100000UNmgooOomg_ABU000@Q7=l>Lh0100000D@Q7NmOomoocg_00L000036<IoogNm00Mg
_@=oo`03AS40000000P0000536=_FgooOomF]@0=00001Be[Oomoogoo=Jd00`0000E6<GooOomooacW
01<0000348Ag_GNm00Mg_@=oo`03F]H0000000800003N05`0G0100=h0@09L05h0G01N05`0GP1L05h
0G0100=h0@06L05h0GP1N05`0F014@0000<l07P1L0400WP100I`0GP1N05`0GP1L042N0402701N05h
0G01N05`0GP1L042N0400g01?000000A000001P00003CW9cO0@Q00D0000A@Q1oogooOomNm`@Q000Q
27oo>Lh<1aQY4>X@21@988]cO002Ool037=l9</D2A@98>TTbb2;66TTbdGcOomS609>=0=5l`09EYMo
ogooOomFUa@950PHJB2;00<aS08U:@03>8LXQf<H009oo`03Lg`Xj36<00<]J`03<H`]Jc6<00@]J`06
@Q1g_GooOomJeRe[136<00HYBbDY7@PHi`S56F/3Ool00bi>2<D<H`0248@01@S548@X@aS6?Nl00goo
00<iDA@900000`000V]J00<<H`0000001`0000<]JgNm48@00`0000H48F]JOomoof<H124200000d8@
Lg`48@0300001@aSKe]oogooBU801`0000@48EkgOom240@mk`03>LiS67oo009oo`03<H`0000000P0
0005125S67ooOomS600=00001B48MkeoogooAS400`0000DicWooOomoobU;01@00003CW=oodib00Dm
k`05E[EoogooOom2400400001V01N05h0G01N05`0@Eh0@0:L05h0GP1N05`0GP1L05h0G01N042L040
0c`00000000@00000f01N05`0@02N0401W01N05h0G01N05`0@9h0@06L05h0GP1L05h0G010gP100=8
0@0000004@00000H00000bU;OolDa@0400000`@QE[Eoo`02Ool01TYB00000000E[Eg_@8HJ@0548T@
20`748UW7002Ool01WNm98dD21@988/Tb`<HJ@0388]_FeJG008D200450TD21@8>E43Ool01SUA50TH
JAQY88/aS08]J`05<H`e9bQ3:>QJeP02Ool01GNmABP]Jbe[<H`01Be[00DaS2e[<H`e[GNm009oo`04
HaPicSW>>Lh6?Nl00cF]?Nmg_@02Ool014Ha36<@Q0`70PSU00D48BQ334P^CWNm009oo`09BS4lk1S6
7>LQ24HaOomcO1BU00T0000348Ag_C6<00<000057>Mg_GooOomBU00300000`aSMke2400300001@@Q
HaQoogooF]H0200000<]Jgoo6<H01@0000EBU7ooOomg_AS600/00005DYAoogooKe/48@0<00001PaS
MkeoogooF]H48@800005;F]oogooOolicP0D00000aBUOolaS00500001D8@Oomoogoo9BT01@000W01
00Mh0G01N05h0G01N05`0@02N0401G01N05`0GP1L0400gP100=`0GP1B040500000=P0GP1L0400WP1
00A`0GP1N05`0@9h0@04L05h0GP1L045N0400dP10000000B000001P0000336=cO3W>00@0000336=[
FWoo009oo`0==Jd00000000HigNmCS@HJBU;8>TTbb2;HaP00goo00<e[a@850T00QQY00PD2A@850PD
2DGcMkdHJA@90a@800IF]GooOomg_C6=50T266T02BC;;F/]Jc6<;H/]JbR7>6=6D`03Ool00dW>;F/]
J`02;F/00c6<;F/aS004;F/00c6<Ke]oo`02Ool;Mkd3Ool00e[F2<H@Q00336<01A2436<<B1U[Mkd0
0goo0WNm17oo00=g_B4800002@0000=Nme:D00000P0000D]JgooOomoocg_00@00003AS5g_A240080
0005125F]GooOomS600800000`@QHaQJeP0400001PaSJeYoogooKcX48@/00005@Q1oogooMkdHaP0=
00001FmKOomoof<H12400P0000DHaWNmOomooe:D01D00003DYA[FP@Q00@00005F]IoogooMkd@Q005
00000c`0L05h0@02N0400g01N05`0@02N0400g01N05`0@04N0401701N05`0DP15P0000AP0GP1N05`
0@9h0@0=L05h0GP1L05h0G01N05`0GP1L05h0G01B0405@00000I00000eJeHaP0000300001QBUMkeo
ogooMkdQ20@00008DYAoobC;<Hd]Jc6<;F]S60=oo`04>E4D21@850T250P02a@950PD21QYLga5la@8
66TPRbU;Ia`00Woo00QcO2B=50PD2AQY88/]Jc6<0Re[00@hQbR7>6=9cP=oo`04CQ8]Jbe[<H`5;F/0
1C6<;F/aS2e[HaP00Woo00Yg_EkgE[EJeUJeF]IF]E[FE[EJeP9F]@09LgaoogooKe/]RbDY7BTX`bQ3
0088a@0330LXQg=l009oo`06JeXel2f;=Je6<FmK0Woo00<]J`000000200000<icWNm36<00P0000E2
47ooOomoobU;00@00003125g_DHa00<00005CW=oogooKe/48@0800000c6<OolDY@0300001A24Mkeo
ogooF]H0300000DaS7ooOomg_BDY00d00005F]IoogooMkd<H`0300001F<HOomoofmK1240500000<L
igoo:D/00`0000H48FmKOomoof]J124700000f01L05`0@03N0400g01N05h0@03N0401W01N05`0GP1
H04l01P00004?01h0GP1L043N0400g01N05h0@05N0400g01?000000E000001T00003<Hag_A2400<0
00069BUoogooOomcO124100000PDYGNmEYLYBaQY4>XPjEKF0goo00=5la@950P01Q@800PHJDhdMkdT
bb2;66TTbfmK0Woo00=_Fb2;50P00QQY00XPRc6<;F/aS2e[:8LX@be7@Beg_@9oo`04DY@]Jbe[;F/2
<H`00be[<H`]J`04;F/01e[FOomoogNm>Lh]Jc6<00@]J`05<H`]Jc6<;F]S6002Ool017=l>LhaS2f;
0Re[00DM20SU48@X@f<H009oo`03HaP=900000800004125BU7oo?Nl:00000aS6MkdYB`0200001EJe
OomoogNm6<H01@0000<mkgNm6<H00P0000E247ooOomcO12400P00003125[FTic00<000059BUoogoo
Oom2400<00001B48Oomoogoo=Jd03@0000E:DWooOomooaBU00<00005AS5oogooOolQ200E00000eJe
HaP48@0200001AS6MkeoogooDY@02@0000<l0601L0400W011GP100E`0GP1L05P0C`001`00004B05P
0F01L042N042L043N0400f01?000000G000001T0000348Ag_CF]00<00005@Q1oogooOomS60060000
0e8dOolYB`0240P00`a8AO=oo`02Ool0158d50TD21@90aQY0b2;00<TbgNmAO<00Q@800HTSGooOomo
oekh50P250T00aQY88/aS002;F/2<H`012e[<H`e[G=l0Woo00=S636<;F/01Re[00DaS2e[<H`]Jdic
00=oo`07AS4]Jbe[;F/aS2e[<H`012e[00QJeWooOomg_Cg_;F/aS3F]0S6<00@YBbe[:<=Nm`9oo`03
Ke/Pj@0000<0000348Aoodic00/00005HaQBU00036=[FP02Ool00f]J36<0000400000`@QMke>L`02
00001CF]OomoogNm7>L02@0000<]Jgoo5:D00P0000DmkgooOomoobU;00`000056<IcO7ooOom6<@0=
00001CW>Oomoogoo9BT00`0000DQ27ooOomoodYB01D000036<IoobDY00800005;F]oogooOolicP0<
0002?005B042?00Q0002?002B0401601B04l03`06`00000J00000f<HG_L0000200001EJeOomoogoo
DY@01P0000LHJGooCS@D2A0850TiD@03Ool015JG50TD2AQY0R2;0QQY00DD2A@850QFUfmK008HJ@07
=M1oogooOom>=1@950P00QQY00XTbbe[<H`]Jc6<7>LHaQcW7BU[FP9oo`09JeXaS2e[;F/aS2e[<H`]
Jc6<00@]J`05AS5oogooOom>L`02;F/00c6<;F/]J`03;F/00c6<;F]>L`03Ool01Cg_<H`LibU;;H/0
0S6<00<]Rbe[E]H00goo00<Tb`0000000`000V<H00<48@000000200000DicWNm000HaWNm009oo`03
HaP48@0000D00005=Jeooa24000YB`02Ool00gNm9BT0000800000`@QKe]:DP0200001E:DOomoogNm
5:D0300000D@Q6]JOomooeJe00d000059BUoogooOolaS00300001P@QHaQoogooLg`<HaD0009JeP80
0005@Q1oogooOolQ201I000001X00006?Nmg_A2400048Flj0goo00<icP000000100000@<1dhdOolT
S@8D2@05>E5oogooOomS600250T00aQY50PD200250P020`766THJBB=Oom5lb2;CS@3Ool03dE_50PD
2A@966TPRbe[<H`]Jc6<8@PHaRDY8@QNm`02Ool00g=l<H`]J`06;F/01S6<;F/aS2e[?Nmg_@9oo`03
F]HaS2e[008]J`03<H`]Jc6<00<]J`0>AS5oogooOolmkbDY36<DYAS68@P]Jbf;<HaBU0=oo`03;AD0
000000<00003>Li[FPaS00X000045:Eg_AcW8@P3Ool00eJe0000000500001@aSKe]:DP007>L00goo
00<aS0000000200000DaS7=l36<006]J009oo`03JeX0000000`00005HaQoogooHaP48@0<00001ABU
Oomoogoo@Q00100000DaS7ooOomoocF]01D000057>Mg_ABU001JeP02Ool00gNm5:D0000300000aBU
6<H0001B000001X000055:EoocF]000@Q004Ool00bU;00000004000021@89<]g_DYg40PD2BU;Mkd2
Ool00fmK88/D200350P011QY88/PRb2;0QQY00AB=7=l66UB=0=oo`0398dD2A@8008HJ@0388/aS36<
00@]J`039BTQ25:D009oo`0;Mke242e[;F/aS2e[<H`]Jc6<;F/]R`02;F/01c6<MkeoogooHaP]Jc6<
00H]J`04<H`]Jcg_Mkd2Ool00dYB9BTDY@0348@2:D/00b48?Nmoo`02Ool00cG@0000000400000`@Q
0000000:00000f<HCW<e[@03Ool00dHa0000000600001C6<Ool@Q1S6Lg`00Woo00<mk`0000002000
00D48F]J?Nl007Nm009oo`03DY@0000000`00005DYAoogooJeX@Q00<00001@@QMkeoogooDY@01000
00H48EkgOomoof<H124<00000bU;;F/00006000015JeCW<006<H0Woo00YS60@Q00048DHaJeY2459c
G_LLie4000006`0000AS65[F000YB`Aoo`037>L0000000@0000830LPReJeOole[b2;=Jmg_@9oo`03
Lg`TSAQY00@PR`DHJ@04<HeoocUAG_P2Ool00gNm50TD200250T0122;=JlaS36<0be[00@aS1cW7>M6
<@=oo`05AS4]Jc6<;F/aS003;F/01S6<@Q0aS36<;F]_F`9oo`05Lg`aS2e[;F/aS002;F/01S6<;F/]
Jbe[=Jeg_@9oo`0:F]H]Jbe[:D/Q22DY;F/U:ABU=Jd3Ool00dic0000000900000a24124000050000
0cF]LgaJeP03Ool00c6<0000000600001@@QLga:DP@QKe/00Woo00=:DP0000002@0000<e[F]J:D/0
0goo00<icP0000000P0000<48BDY00001`0000E247ooOomg_AS600L0000336<Li`0000800005125S
67ooOomS600500001AcWOomoogoo>Lh0300000=>Lf]J00001P0000@Q27=l9BU[FP9oo`06DY@00000
G_LYBaBU0P0000<YBe9c:D/0D000000K000013W>Mkd<Hcg_0goo00=g_@@Q00001@0000P<1bC;@Q1g
_F<H:D/e[gNm0Woo00=g_BB=66T011QY1R2;00=BU7NmMkd00Woo00UNn1@850TD21QY9<]cO5[g;F/0
0S6<12e[00E6<GooOomoodic00H]J`04<HaBU7Nm>Lh2;F/01f<HOomoogNm>Lh]Jc6<008]J`07<H`]
Jbe[<H`]Jc6<Ke/00Woo00][FS6<;F/]Jc6<=JdaS1cW5:D]RgNm009oo`03F]H0000000P000038@Q_
FaBU00H0000348Ag_Goo009oo`03MkdQ200000P00004@Q1g_AS6G_L2Ool00eJe0000000900000`aS
JeY_F`03Ool00bDY0000000200000aBUMke2400700001C6<Oomoogoo9BT01`0000=:DVmK00000`00
00EJeWooOomcO0@Q00D00005?NmoogooMkdHaP0;00000ekgLg`0000700000f<HLgag_@02Ool033W>
0012436<001S60009BU24000G_L48Dl000006`0000@DYGoo;F]>L`=oo`03JeX0000000D0000830LP
jB3YCSAoobU;66U_F`=oo`03<HdD222;008PR`<HJ@8D2@0450P<1b2;Mkd3Ool00dhd50TD200250T0
11QYCSAooe:D1Re[00lmkgooOomooekg<H`]Jc6<;F/aS2e[<HacO7Nm<H`00Re[00MJeWooOomood8@
;F/]R`03;F/01S6<;F/]Jbe[<HaS609oo`04Mkd]JaBU5:D26<H01BDY5:D<Hbe[Ke/00Woo00=[FP@Q
00001`0000@@Q6]JOol48@L00006G_MoogooOomg_@aS2@0000@48G=lE[EJeP9oo`03HaP48@0000X0
0006>LioogooOomg_A241@0000=>Lgoo;F/01P0000DQ27NmOomoocF]00H0000336=_Fekg00@00005
AS5oogooOolHaP0600001DHaOomoofmK48@02@0000@<HfmKMkd48@L000039BUoogoo009oo`039BT0
06]J00800007G_L006]J124003W>8@P0C`00000K000010@QHaQNmf<H0goo00=BU00000001@0000P<
1a@934PYBgooHaPPjF]J0goo00<iDA@966T00QQY0Q@800@@21@850PD208HJ@06CSAoogooOom5Ka@9
0Q@80QQY00/mCGNmOom>Lbe[<H`]Jc6<;F/aS7Nm009oo`04HaPaS2e[;H/3;F/01eJeOomS62e[<H`]
Jdic00=oo`04CW<]Jbe[<H`3;F/01C6<;F/]Jbe[F]H00goo00DmkbDY7>LHaQBU008Li`0336<]Jf<H
009oo`03Mkd<H`0000H00005125F]GooJeX48@0700001DHaOomoogooJeX02`0000<icWooLg`00Woo
00=[FPaS00002P0000H48FmKOomoof<H1245000011S6Mkeg_BDY1@0000DDYGNmOomoodHa00H00003
@Q1oodHa00@00005>LioogooOol]J`0700001E:DOomoof]J5:D0200000@aS7ooMkd@Q0L00008125J
eWooOomcO1BU001S60800007Mke[FWNm:D/001cW@Q00C`00000L00000cW>Oomoo`03Ool00d8@0000
0005000021@840PPjBU;DYAoocG`HaP3Ool00dGc50PD200350P266T00b2;9</Tb`0288/01RC;Mkeo
ogoo98dD20<D2@0366TPRf<H009oo`03F]He[Bf;008]J`06<Hag_GooOomg_C6<0Re[00<]RcF]DY@0
0Woo00ENmbe[;F/]ReJe00=oo`03JeXaS2e[008]J`03<H`]Jbe[00<]J`05G_MoogooOomJeP03<H`2
;F/012U;8BP]Jf]J0goo00<]J`000000100000D48DYBOomooekg00P00005F]IoogooOomJeP0;0000
0`aSKe]oo`02Ool00gNm8BP0000;000013F]Oomooe9c1`0000EF]GooMkdicPaS00<00005125g_Goo
OomNm`0400001@aS>Lig_Goo=Jd0100000E247ooOomooeJe00L00006125>LgooOom_Fb4X1P0000DH
aVmKOomooacW00P000079BUoogooHaP48A24E[D00P0000MS6000001S6000>LhaS01?000001`00003
7>Mg_Goo00=oo`03;F/0000000D0000830LHJBU;34P@RGNmEYMNn0=oo`03CS@D2AQY008HJ@8Tb`05
88/HJAQY66TD2@0250P00dhdOom_F`0250T250P266T00b2;@Q1oo`02Ool00gNmJeY[FP02JeX4Ool0
1FmKJeY[FV]JKe/00goo00EBU4icHaQS67Nm00Aoo`04Ke]S65kgAS42;F/013F]F]IS66]J1Goo00Q[
FV<HG_Lmkc6<E[ES66]J17oo00Eg_EkgG_MF]E:D009>L`05HaQoogooOomBU004000011S6CW=BU5[F
17oo00=6<@0000002P0000<e[GooOol00Woo00EcO5JeCW<mk`@Q00P00004125[FWoo>Lh700001AcW
MkeoogooJeX00Ukg00=JeV<HOol00goo00ES65[FG_MNmf]J00=oo`068@P48CW>DYAF]GNm17oo00AS
65:DCW<Q20D0000?9BUS67ooMkeJeSF]5<D@Q248AS5cO7ooKe]oocF]00T00003F]Iooe:D0080000:
@Q0U:@00Ke/mkd8@F]H005kg125?000001`0000336=[FWoo00=oo`036<H0000000D0000830LPRb3Y
40PD2DGcMkeS60=oo`03DS@D2AQY008PR`0766TD21@850P@21@840P00Q@800DTbgNmHaPHJA@8008D
2@0:50PHJB2;;F]S67ooMke_Ff]JKe/2Lg`01VljJeY[FV]JLga_F`9cO09_F`07MkeoodHaHaQoogNm
Lg`016mK0WNm00Eooe[F<H`]JcW>00=g_@03Lga_FfmK009_F`9g_@09Oom>Lc6<HaQoogNmLga_>VLL
009S6003JeY_FfmK00=cO005MkecO7=lMkdicP0400001248Oomg_G=l0V<H00=[FWNm:D/0300000@4
8F<HLga[FP9S6004Lgag_G=l5:D900000c6<OolYB`0800001f<HOom_Ff<HJeYS66]J009S6007G_MS
66<HHaQ[FV<HJeX00V<H00Qg_Goo5:D48EkgOomcO6]J16<H00A_Fg=lMke240H00004124YBf<HOol4
Mkd01WooKe/icPaS8@PHaPT000038@Qg_Cg_00<00003HaPQ2248008Q2003125>LcW>050000007000
00<48FmKOol00Woo00=g_@aS00001P0000L<1b2;4>X@21@988]g_@04Ool01f<H50TD2A@950P@21@8
008HJ@0388/HJBC;008Tb`0488/iDBB=50T250P250T031QY88/]JdYBHaPe[C6<9BT48BDY<H`YB`8D
Y@039BT]Jc6<00@]J`04>LiS63g_;F/3<H`5;F/3<H`3;F/2<H`01Be[<H`]Jbe[<H`00Re[0S6<0Re[
0S6<00D]Jc6<;F/YB`aS00L00004124000@Q124700000`@Q0000000G00000`@Q0000000900000`@Q
:D/48@0800000c6<AS40000?00000aS6CW<48@0200000`@Q0000000600000`@Q0000000800001PaS
8@PYBbU;8@P@Q0l000039BT<H`00008000071256<Ekg@Q1BU6<H:D/0D@00000I00001@aS48@DaCg_
Mkd00goo00=S60@Q00001P0000L<1aQY:D/<B10850U>=004Ool00gNmAO<Tb`029</488/266T00b2;
66THJ@0350P011@950PD2A@80QQY00<PRbe[<H`00Re[00TaS2U;124Q236<9BT48@aS9BT00S6<00@]
Jc6<<H`]J`8aS08]J`07<H`]Jbe[;F/aS2e[<H`00Re[014aS2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/a
S2e[<H`]Jc6<00<]J`05<H`]Jbe[<H`48@2;00000aS61240001B000001P000046<IS67=lLg`5Ool0
0eJe12400006000020`750PYBbC;34PD2BB=Mkd5Ool017NmLgacO3G@0QQY00<D21@950P00a@800HD
2A@850TD21@950P250T01AQY88/]Jc6<;F/00S6<00XLi`aS7>LaS1S6124Q23F]<H`Q20<]J`8aS004
;F/]Rc6<;H/2<H`5;F/00c6<;F/]J`03;F/00c6<;F/]J`09;F/00c6<;F/aS002;F/00c6<;F/<H`3P
000001P0000536=>Le[FDYA:DP02AS400dicF]HYB`08000010`750PTbb3Y0Pa800@@24hdG_QFU`=B
=006EYMNn6<H>E4PRaQY0Q@800<D2A@850T00a@800DD2A@850PD2A@8008HJ@0388/]Jc6<008]J`0<
<H`Q21C57>LaS1S648@Lic6<;F/@Q2e[0QBU0aS60QcW00<YBbe[;H/00S6<00<]Jc6<;F/00be[00la
S2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`00be[00DaS2e[<H`YBa240>000000:P0000L<1aQY
:D/Tbb3Y50T<B00240P250T011@850TD222;0aQY00TD21@950PD2A@850TD21@950P00Q@90a@800PD
2AQY88/]Jc6<;F/aS2e[0R4800hLibDY8@P<Hb48<H`U:@@Q9BTLibDY36<DaABU0Q2400DYBacW8@PY
Bbe[008aS004;F/aS36<;H/5;F/00c6<;F/]J`08;F/01c6<;F/]Jbe[<H`HJ@`70>000000:P0000T<
1aQY8>T@RBDY9</@R@a840P00a@91a@800<D2A@850T00Q@80Q@90a@800HD2A@850TD2AQY9</4<H`0
4B4X8@PQ21BU8@PU:@aS9BTaS2DY48@Lic6<:D/@Q2e[:D/00QBU00haS12448@Q21BU7>LQ236<;H/a
S2e[<H`]Jc6<12e[00DaS2e[<H`]Jc6<008]J`03<H`]Jbe[008]J`04<H`]JaQY30OP000002X00006
30LD210834PHJA290R3Y00<@RA0850T00Q@800`D2A@850TD2A@850TD21@950PD2A@850T250P250T0
0a@850TD2@0266T00bC;<H`aS002;F/02R48:D/Li`@Q9BTQ:0aS:D/Q:1cW0QS600<e[BDY5:D00S6<
01@@Q248<H`DYAcW9BT<Hb4848@U:AcW:D/]Jbf;;F/aS2e[<H`]Jc6<1Re[00HaS2e[;F/aS2e[<H`2
;F/00a@81240003O000002X0000>50PHJ@a830LPRa3Z:D/aSBU;50TD21@950PD2@<D200550TD21@8
50TD200250T00a@850TD2@0250P00a@950PD200266T052U;<H`]Jc6<8@PDYBU;8@P48BU;9BT@Q2e[
7>L@Q1BU7>LaS2DY5:D2<H`010aS7>LaS1BU0RDY00XDYBf;8@PYBaBU7>LaS2U;6<HQ:08]J`04<H`]
Jbe[;F/3<H`2;F/00c6<;F/]J`02;F/0136<;F/Pj@`7h000000Z000010`788/YBaQY0Re[00PYBb3Y
66T@21@950PD2A@80Q@900@D21@950PD2@HD200640PD210850PHJA@90QQY00HTbc6<<H`]Jb485:D2
9BT031cW:D/LiaBU;H/U:Be[7>LDYCF]8@PDY@8aS00436<DYAcW36<29BT04AS69BT]Jbf;5:DHaS6<
6<H<HbU;;F/HaS6<48@DYAC58@P00RDY0S6<00@]Rc6<;F/aS08]J`03<H`]J`@Q0>000000:P0000H<
1aQY<H`aS2U;8>T248T00bC;40PD2@0250P011@950PD21@90a@800H@21@866TD210850T266T0322;
9</PRa@866TPRbU;<H`]Jc6<;F/YB`@]J`0:5:D@Q1cW7>LaS2DY48@]RacW5:D2<H`01Q24:D/Q:0aS
:D/U:@8@Q00=;F/YBaBU5:D]Ja246<HaS2DY48@U:B485:D00QcW0QBU00D]Jb486<HYBbf;008aS08]
J`03<H`<H`000=l00000:P0000d<1a@8<H`Tb`a840P<1aQY:D/@21@950PD2@0550P01a@966THJB2;
:D/PRbU;00<]J`03:D/Tbb2;00<HJ@079</e[C6<<H`YBb48;F/00c6<00PU:BU;6<H@Q2e[8@P48BDY
0QBU01`e[Be[36<e[BU;48@]Jb486<HLibe[9BTHaQBU;F/DYAcW<H`U:A24:D/]RaBU9BT]JaS68BPU
:@8DY@088@P]JbU;;H/]Jc6<;F/@Q>000000:P0000P<1aQY8>T<B10850TD21QY0Q@800DD2AQY66TH
JB2;00HTb`0388/]Jbe[008Tb`8PR`8HJ@8D2@8HJ@037@PU:Bf;008]J`068@PQ:2488@PU:BU;0S6<
00D]Jc6<8@P@Q248008@Q007;H/HaPaS:D/Q20aS;F/00R4801daS2e[9BTU:A248@PHaQcW<H`Li`aS
9BTe[A24:D/aS1cW:D/DYAS69BTQ22DY36<Lic6<:D/HJABU0>000000:P0000@<1a@966TD208D2@07
50PD2A@850TD222;;F/00RC;00TPjBC;9</YBaQY88/HJB2;66T00Q@800H@21@840PD21@966T288/0
21cW<H`icS6<;H/]JbU;9BT38@P29BT05B488BP]JbU;;F/YBbDY;F/Q21cW9BTHaP@Q9BT<HacW9BTH
aR4X;F/@Q0028@P051S69BTHaQ247>LaS124:D/e[AcW8@PDYBDY<H`]Jb4836<U:C6<9BT230OP0000
02X000<D200650TD21@850TD21@90Q@800<PRb3Y:D/00R2;0QQY0Q@900<D210830L00Q@800@PRbB=
98dTS@8iD@90m@06?;E>6G=lHaQBU48@0THa00He[Be[;F/]Jbf;:D/28@P00bU;8@PQ20039BT022U;
;H/]Rbe[8BPU:AcW6<H35:D03Re[5:DU:AcW6<HQ:2U;9BTHaS6<5:D]Jc6<8@P26<H022e[;H/aS1cW
6<H]Jc6<9</230OP000002X0000530LD21@850TD200250T250P00a@950PHJ@0250T02a2950TD21@8
66TPRbB=>E4X<CBf@?D00Sbe00DlMc@E=1D`=3@E008lM`04BAQg_GNmLg`2Mkd01g=lJeYF]EJeCW=6
<CF]008]R`05:D/U:BDY8@PQ:0028@P00acW9BTU:@02:D/4;F/06b4X;F/YBbe[7>L@Q1BU9BTQ21cW
<H`DYC6<=JdQ21BU6<H]Jc6<:D/@Q1S6;F/aS2DY66T<1`3P000002X0008D200350TD21@9008D208D
2@8D200850THJBC;98dlk2RD<3@l]@8hM@8d5@<`=00461<`=30d>1H2@7P013PF@9M967=N0WNm0W=l
1GNm00UcO6]JJeYS65Je@Q0aS2f;<H`00Re[0RU;0RDY0R4800<U:B4X9BT00RU;00`]Jbf;:D/U:B48
9BTLia249BT@Q2e[<H`27>L01QS6;H/YBb487>LHaP<]J`03:D/48@000=l00000:P000a@800@HJA@9
88/TS@8aS@07>E4l]C@E>1Hd5C0d=1D00S0d00Dd5C0d=1DhMCBf0094f004DEYEnUjLEOX2GY`02DCH
>7DlUdTHMkeoogNmJeY:DP03E[D00f<HJeY_F`02Lg`01gNmLgag_GNmLgaS65:D008icP8e[@<]J`03
:D/U:BU;00DQ200F9BT]Jbf;;F/U:B485:DaS2DY124Q21248@P@Q1cW:D/HaRe[<H`]Jc6<36?P0000
02X0000330`iDCUA008iD@07>7Dd5C0d=1Dh5SPE=1D00S0d0T4G00=4f5GjDEX00TSi00mAFW=NLei_
FgooLeibgFLLEOYNW42G>7E0UdTHLeh00WNm00McO5kgKe]JeU:DCW=6<@02G_L01THaE[ES65kgKe]c
O0Ag_@03Lga[FTYB00=2400:>Lh]Rbe[:D/U:B4X8@PQ:2DY8BP49BT032f;;F/U:Be[:D/Lib4X9BTQ
:1BU:D/]J`8aS00336<000000=h00000:P000S0d0S@E0SPF00Pd5CPE>1Hh5C0d@9M4f6LL0eGj00IN
W7NmGYaNW55JIa`2DEX01dSi?;Dd]SQe=;HlUc@E008lM`04BAQg_GNmMkd2HaP00gNmOomoo`02Mkd0
1W=lKe]Nme:DJeY6<@92409F]@9S6003Lga_FgNm009g_@07LgaS65[FE[E>Ld8@<H`00bU;00<U:B48
8@P00R481RDY00TYBbe[:D/Q22U;<H`]JbDY7@P0h000000Z00003cPC>1Hh5S@E>1Dd5CPF=1Dh5CPF
61=5fG=NIaaAFP02GY`01U5JB?U0N30dDEYNW08L508`=0@d5@0>>1E0Ud2GBAQcGWNmOomBU1BU@Q1c
O6]JMke:DP=cO003MkecO7Nm009cO009DYANmdYBBU9JeU:DE[EBU5[F009[FP04MkecO7NmLg`2JeX0
0ekgE[E24002:D/2;F/00bU;9BTU:@02:D/29BT28BP01RU;;F/aS2e[66T<1n000000:P0000@X<C@E
=1Dh5P8d5@07>1Dd5CPF>1Dd5DCHEOX00TCH00<lMc@E61<00S0d0S@E00<`=3@E>1H00SPF00Ph5C@E
>1Dh5CPF>7DlUdTH0gNm00iood8@LgaNmaS6Ke/mkaC5:D/HaW=lAS4aS5[F0V<H00=g_G=lOol00W=l
0V]J0UJe00M6<EkgCW=>LdYBG_M[FP02Ke/047=lMkeg_F<HCW<mkcF]<H`e[C6<;H/]JbU;9BTQ22DY
0S6<00<HJ@`70000g`00000Z00000bPa>1Hd5@02>1D033PF=1Dd5C0d>1Hd5CQe=1D`=3@E<3@d5@<h
5P03>1Dd5CPF008d5@0?>1Dd5C@E>1Hd5CPF>7DlMd2GBAQcGWNmLgaooe:D009S600C001NmgNm9BUo
oe[FMkeJeP@QCW<DaB48Lg`aS3g_G_MJeUJeHaP00goo00AcO6mKHaQNm`=:DP0;G_MBU5:DF]IS66]J
Ke]g_G=lG_M>L`02@Q0023g_=JdQ:2DY;H/U:ABU30OP000002X00003>1<d5C@E00@h5P04=;Hm5a`D
>1H2=1D05SPF=1Dh5SPE>1Hd5CPE=1Dh5CPF=1Dh5S@E>1Dh5S@E>1Hd5CPF?7LlUdTH0gNm01mooekg
DYANm`aSDYA_FacWLgaNmgooG_LLigNm?Nle[GooDY@DYF]J=Jd48EJe9BT]Rbe[HaQF]G=lOomg_@02
Lg`02GNmJeYS65JeAS5245JeG_M>L`02HaP02VmKMkecO6<HF]IF]E9c?NlM21BUh000000Z000012Pa
A=Pi]P`A0Q`D00DH4dGIMkdL53PF008h5@05=1Dh5C@E=1Dh5@02=1D02CPF>1Dd5CPE=1Dh5S@E>1Dd
5@03>1D2@9L00dTHMkeg_@02Mkd02W=lCW=JeS6<DYA[FQBUHaQ6<Be[0SF]01Eoodic;F]oog=l8@Qo
oe:D9BUcO3W>BU9NmbU;8BQNme:DKe/aS4HaCW<00g=l00M_Fg=lLgacO6<HG_MJeP03CW<01eJeF]I_
FgNmKe]243F]0>000000:P0000dX<CBfOomNW4GI?ALM<S4f?ALL53PF=1Dh5P02=1D013PF=1Dd5CPF
0S@E00Lh5S@E=1Dd5CPE=1Dh5P02=1D01SPF>1DhMCbGBAQcGP9g_@03Lgag_EJe0096<@0;G_M[FQS6
E[E_FdYB>Li247ooE[D]J`02Ool06248Oom[FR4XLga6<DicOomF]E[FOolYBf]J>Lhe[Bf;Ke/]JbDY
?NlaS6mKJeYNm`9g_@0:Ke]oogNmHaQF]E[FMkecO2dE48WP000002X00004:34d]WooMkd3Ool01G;M
GY``=3@E>1H00c@E130d00@h5S@E=1Dh5@8h5P07=1Dh5S@E>1Dh5SPE>1H00T2G03I967NmMkeg_G=l
Oom>Lbf;@Q1g_DYB9BU:DWooG_LicSg_Oom[FRe[Oomg_AcW@Q1:DQS6MkeF]DicF]Ig_EkgJeX]Rdic
BU9>Lf<HOomF]DHaMkdU:GooE[D48F<H>LhYBdYBCW=g_F<HLg`2Mkd00cbe6100003O000002X0000<
:358nEkh315NW1dbAMUoocVf71@h5SPE0S@E00Dh5SagA=Q5fDTH008h5P8d5@@`=0<d5@06>1Dh5SbG
?9M967=N0WNm011cO7ooDY@<HdHaOole[BDYAS5ooeJe48AF]GooJeXU:@9oo`0A8@Q:DU:D6<Ig_E[F
7>LHaWNmHaQBU2U;CW=:DTHaF]I:DP02@Q004Goo<Haoogoo=JeJeQcWHaPQ22e[Mkd]JdHaOomcGRPa
6100h000000Z00002CPC>1HXU1`D@ALd]UKF;ADL5002>1H2=1D00cagEOYAFP02DEX01SbG:34d5C@E
@7PlM`98n@09A=Pd5CPF>1Dh5SPE@9LlMdTH00=g_@0HLgag_FmK125>LgooF]H<HdicOom_>QC5HaQN
mfmK7>M[FWoo;F]>Lgoo9BU_FeJe0Sg_00e[FVmK@Q0U:FmK>Li247oo=JdDYDicOolU:@02Ool03CW>
?Nm6<GooJeY>Lgoo>LiJeWooMke>6BB=0>000000:P0000@X<C@E71@<4@9W708L5003>1HD5SPF008d
5@07>1HlUcbeA=PlUe5JGY`00U5J00ENW5GjEOY8nDCH008d5@<h5@0l?7M0UdTHLeig_G=lMkeooc6<
48ANmgooLg`48CF]OomcO2f;Lg`YBdYB7>M>LdHa=JdicWoo:D]S65[F<Ha_FgNmOolicRDYMkdaS3g_
Oom[FR4XG_MoobU;Ke]ood8@?Nm6<GooMkeF]Cg_8BQS67NmLgag_EJeh000000Z00002BPaA=Q6f6LL
EOXL53@E=;H]5@02>1H01S@E@7Q8nEjLEOY8n@996004?ALlMcPF>1H4<3@023PF=1Dh5S@E>1I0Ucbe
BAP5Mkd00dYBE[Eg_@02Mkd02Sg_5<EBU7ooJeYoodic>Li242U;0R4X01XQ25kg6<He[EJe8BQoodic
JeY243g_MkdaS3W>OomBU1cWLgaoobDYHaQoocW>CW<e[Goo0WNm00<aS24XJeX00gNm00=JeP000000
gP00000Z00003RPa?AMoobgD:34h5SBfKe]g_APC>1Hd5CPF=;H2=1D2<3@01A`D>1<L53PC71@00c@E
00Xh5S@E>1Hd5CPE>1HlMd2GBAQcGP9g_@9cO09oo`04MkecO7NmMkd2JeX00g=lOomcO003Ool077Nm
JeY[FUkgJeYJeTHaCW<U:CF]48A[FRDYAS5oodHa9BUg_F]J;H]JeVlj>LiNmgoo?NmS62DY0WNm00Qo
oeJe:D]_>WNmLgaood8@h000000Z000012Pa?9MNW4GI0c@E00DXU6LL71@d5CPF008d5@06<3@d5CPE
?7M4f3ag0UGj00=8nDhIEOX00c@E00Lh5C@E>1HhMCag?9M96004Mkd2Lg`00gNmLgag_@02Lg`00goo
Mkeg_@02Lg`00gNmLgag_@03Mkd01WooMkeoogooMkecO09_F`0FMke_FgNmMkecO2DYDYA_FcF]MkdY
BacW?Nm>Ld8@JeXicTYBJeYS65:D;F/2Mkd00g=N;ADTS@3P000002X0000B:34XU7NmBAPd5CPE>1HH
4ejL?AL`=3@E>1I4f5jLEOYNW5Gj0U5J00EEnU5JA=Q9642G008d5@03>1Hd5CPE008h5@04?7M0UdSi
Leh2Mkd017=lMkeg_FmK0W=l0WNm0g=l00Ag_G=lLgag_@AcO003MkecO7=l009cO004MkecO7NmLg`2
Mkd00g=lMkeoo`03Mkd04WooCW=:DS6<@Q0e[BU;JeXe[BU;DYAS60aSAS5oog=l?;DH4>000000:P00
00@X<D4GIa`H4`<h5@09<3AW730d>1Hd5CagA=Q0UcbG008d]P08:34h5Q`D61<X<A`D=1Dh5@8d5@07
>1Dh5S@E>1I0UcbeBAP017Nm00AcO6]JLgacO09[FP06Lgag_G=lMkecO7Nm0W=l00=g_G=lMkd00W=l
00Qg_G=lMkeg_G=lMkecO7Nm0W=l00Ag_G=lLgacO0=g_@Eoo`04Ke]ooekg?Nl2Lg`01d8@CW=g_G=N
<3@<30@Q0=l00000:P00010X<E5JAMTL53PE>1HH4dGIGY`H4cPF>1Dd5C0d:34L508`=0<h5P04A=Q9
64Si=;H2=1D02CPF=1Dd5CPE>1HlMcbGBAQcGP02Mkd2Ke/01GNmJeYg_GooLg`00VmK00=g_G=lMkd0
0W=l00=g_G=lMkd00W=l00=g_G=lMkd017=l00Ag_G=lLgag_@9cO003MkecO7=l00EcO0=g_@03Lgao
ogoo009g_@9oo`9g_@03>KHH40000=l00000:P0000/X<E5JEYLH4c@E61<]e7oo:9@D5SPF008d5@06
?7M8nEGjBAQAFUjL0eGj00AAFUGj<3@d5@8`=08d5@05>1Hh5D2G@9M96002Mkd01W=lKe]g_GNm:D]>
L`9cO003Oom_Fg=l00=cO005MkecO7=lLgag_@02Lg`01WNmLgacO7NmLgag_@9cO004MkecO7NmMkd2
Lg`01GNmLgag_G=lMkd00W=l00=g_G=lMkd00W=l00Eg_G=lMkeg_G=l009g_@03BU8000000=h00000
:P0000TX<BdEOoli]QdbGYaoodGI31400SPF00@h5C0d=1EAFP98n@8h5P0E<3@hMCQe=;I0UdSiA=QN
W55JGY`lUc0d>1HhMCbGB?UcO7ooKe]g_E[F00=S6005BU8e[Cg_HaQcO002Mkd2Lg`01GNmLgag_G=l
Mkd00W=l00Ag_G=lLgag_@9cO003MkecO7=l009cO004MkecO7=lMkd3Lg`01WNmLgacO7NmLgag_@=c
O006MkecO7NmLgag_EJedP0000<48@0000002`0000001B487>LQ22487>L00b480QcW124800<Lib48
8@P06B4800<`=1PCAMT00Woo00EcGSdG30a>6CPF008d5@05?7Lm5e5J@AMAFP03EOX00e5JB?UEnP02
DEX02T4GBAQ964CH>7Dd5CPF@9LlUdTH0WNm00m_FgooBU8M:E:DG_MS65kgBU9S67NmKe]g_G=lMkd0
0g=l00=g_G=lMkd00W=l00=g_G=lLg`00WNm00AcO7NmLgag_@9cO006MkecO7=lMkecO7Nm0W=l00Ag
_G=lLgacO09g_@AcO003MkeooeJe00HQ20047>LQ22487>L28@P00acW8@PLi`097>L00b487>LLi`0P
7>L00aS67>LLi`027>L00aS67>LLi`027>L26<H00acW6<HHaP046<H00aC55:DDa@025:D25<D25:D0
11C55:DDYAC51ABU00<DaABU5:D05ABU00<@Q1BU48@00Q2411BU0Q2400<DYA245:D07A2400L<Ha24
36<@Q0aS48@<H`0248@;36<020@Q36<<H`@Q36<48@aS124236<00`@Q36<48@0436<01P@Q36<48@aS
124<H`848@0936<48@@Q124<H`@Q36<48@aS00848@8<H`448@4<H`448@000cg_00LicSg_?NlicSg_
>Lhmk`02>Lh00cg_>Lhmk`02?Nl02CW>?NlicSg_>LhmkcW>?NlicP03?Nl02CW>?NlicSg_>LhmkcW>
?NlicP02?Nl01cW>?Nl`=3Bf61<XU1db008<4@0:AMUcGQ`D>1Dd5CPFA=QAFTSi>1H2=;H00c0d>1Hd
5@02=1D3<3@00a`D:34d5@02>1H04SbG@9M967=NMkecO7NmOom_Ff<HAS4aSF<HDYAS67NmLgag_@9c
O003MkecO7Nm00AcO004MkecO7=lMkd4Lg`017NmLgacO7Nm0W=l00=g_G=lMkd00W=l00Eg_G=lMkec
O7Nm00=cO00=MkecO7NmMke0mCUA?NlicSg_>LhmkcW>?Nl00SW>00<mkcW>>Lh02SW>00<e[CW>=Jd0
13F]00<icSF]=Jd01cF]00DaS3F]<H`aS3F]014aS004;F/]Rbe[;H/5;F/00bf;;F/]J`0;;F/012U;
;F/]JbU;0Re[00LU:Be[;F/YBbe[:D/U:@02:D/012DY:D/U:BU;0RDY00<YBbDY9BT04RDY124800<U
:B488@P02b4800HLib488@PQ21cW8@PE7>L00aS67>LLi`0F6<HL5:D000<e[@05>Lhe[CF]>Lhe[@02
>Lh013F]>Lhe[CW>0cF]00TicSF]>Lhe[CW>=JdicSF]>Lh00cF]00TicSF]>Lhe[CW>=JdicSF]>Lh0
0SF]00PicSF]<3A8nDKH314m5fmK0goo00<H4cPF>1H00S@E00Dh4a`D<3@`=3@E008`=08d5@0<>7D`
=3Qe>1I0UdSi?9Ld5CPF@9LlUdTH17Nm00Yi3gB8Mkeg_EkhE[E6<BDYF]Ig_@9cO006MkecO7=lLgag
_G=l0WNm0W=l00Ig_G=lLgag_G=lMkd2Lg`017NmLgag_GNm0g=l00Ag_G=lLgag_@=cO004MkecO7Nm
Lg`2Mkd00g=l:9@<3003=Jd01CW>=JdicSF]>Lh02cF]00DaS3F]<H`e[C6<008e[@03<H`e[C6<008a
S003=JdaS36<00TaS008;F/aS36<<H`]Jc6<;F/aS0`]J`03:D/]JbU;00@]J`069BT]JbU;;F/U:Be[
0RU;00H]JbDY:D/YBbDY;F/2:D/01BDY;F/U:BDY:D/01BDY00<YBbDY9BT01bDY00<Q:2DY8@P00bDY
00DQ22DY9BTQ22DY00dQ20057>LQ21cW8@PLi`028@P27>L00b487>LQ20027>L00b487>LLi`0:7>L0
1AS67>LHaQcW6<H00acW3aS600<DYAS66<H00QS600<DYAS66<H00QBU00<HaQBU5:D031BU00@@Q1BU
5:D@Q0<DY@0348@DYABU00@DY@0348@DYABU008DY@000SW>00De[CW>>Lhe[CW>008e[@8icP03=Jdi
cSF]008icP05=JdicSF]>Lhe[@02>Lh00cF]>Lhe[@03>Lh03cF]>Lhe[CW>=JdicSF]>Lhe[CW>=Jdi
cSF]<3@d]P03Ool01FLLG_PXU5Gj71@00S@E00@h5SBfA=Q4f0=8n@03DEYEnUGj009AFP=NW09cGP0A
B?TX<CPE?7M0UdSiMkecO7NmLga]LGT?MD]ilGT?Oomk6@02Ke/2Lg`01GNmLgag_G=lMkd017=l00Ag
_G=lLgag_@9cO004MkecO7=lMkd4Lg`01GNmLgag_G=lMkd00W=l00=g_G=lMkd00W=l00ag_G=lLgag
_G=N?;DH43F]>Lhe[CW>=Jd2>Lh01SF]>Lhe[CW>=JdicP/e[@05<H`e[CF]<H`e[@04<H`00cF]<H`a
S008<H`02Re[<H`]Jc6<;F/aS2e[<H`]Jc6<32e[0bU;00d]JbU;;F/]JbU;;F/U:Be[9BTYBbe[9BT]
J`039BT012e[9BTU:BU;0RDY00<YBbDY:D/032DY00PPjBDY9BTU:B489BTQ22DY0R4800<U:B488@P0
424800<Lib488@P00QcW00<Q21cW8@P03acW00@HaQcW6<HLi`8HaP057>LHaQcW6<HLi`0<6<H00aBU
6<HDY@026<H25:D01AS65:DDYABU6<H03ABU00<@Q1BU5:D00Q2400<DYA245:D02QBU0002=Jd01CW>
=Jde[CW>=Jd00SW>0SF]00<icSF]>Lh00SF]00DicSF]>Lhe[CW>008e[@03>Lhe[CW>00<e[@0;>Lhe
[CW>=JdicSF]>Lhe[CW>=JdicP02=Jd042Pa?AMcO4GI=;HL50`A>KIEnS0d>1Hd5CPFA=QAFThI0TTH
00Q15dTH@ALm5cBf>1Hd]SbG0SBf0SPF014d5CPF?7Ll]DTHLeig_G=lMkeoogYFH:Qj4gE?KG5l17YF
009g_@09Ke]g_G=lLgag_G=lMkecO7Nm009cO004MkecO7=lMkd2Lg`2Mkd017=lMkecO7Nm0W=l00Ig
_G=lLgag_G=lMkd3Lg`017NmLgacO7=l0WNm00QcO2RD30`icSF]>Lhe[CW>0SF]00<icSF]>Lh03CF]
00TaS3F]=JdaS3F]<H`e[C6<=Jd02c6<00@]Jc6<<H`aS08]J`04<H`]Jbe[<H`@;F/012U;;F/YBbDY
0be[00hYBbe[:D/U:BU;9BT]JbU;9BTYBbDY:D/U:BU;1bDY00<YBbDY9BT02BDY00DPjB4X9BTU:B48
008U:@058@PQ:2DY8@PU:@0?8@P00acW8@PLi`028@P27>L00b487>LLi`0?7>L01AS67>LHiaS67>L0
4aS600LDYAS66<HDYAS65:DHaP035:D00aS65:DDY@0:5:D011245:DDYA2431BU000013F]>LhicSF]
0SW>00Pe[CW>=Jde[CW>=JdicSF]0cW>00Te[CW>=JdicSF]>Lhe[CW>=Jd00cW>01Pe[CW>=JdicSF]
>Lhe[CW>=JdicSF]>Lhe[C0dDEY>6APC<3@h5C@EEOYg_A@F=1D3>1H3=1D0130d=1Dd5C0d13@E00``
=3@E<3@`=3@E>1HhMCag@9M967NmLg`2Mkd03WYFL05j]WooMke`HgYFM8QcO7NmLgag_G=lMkd3Lg`0
17NmLgacO7Nm0W=l00Ag_G=lLgag_@AcO004MkecO7=lMkd2Lg`01gNmLgacO7=lMkecO7Nm009cO09g
_@05Lgag_GNmLgaFU`02=Jd02CW>=JdicSF]>Lhe[CW>=JdicP0:=Jd01S6<=Jde[CF]<H`e[@8aS005
=JdaS36=<H`aS@0<<H`01Re[<H`aS36<;F/aS08]J`03<H`]Jbe[00/]J`04:D/]JbU;:D/2;F/01BDY
:D/U:BU;9BT00be[00HYBbDY;F/YBbDY:D/29BT00bU;9BTYB`029BT00bU;9BTU:@0>9BT01b489BTQ
22DY8@PPjB4X008Q20038BPQ224800TQ20037>LQ21cW008Q20097>LQ21cW7>LQ21cW8@PLib4800`L
i`076<HLiaS67>LHaQcW6<H00QcW00@HaQcW6<HHi`XHaP035:DHaQBU008HaP055:DHaQBU5:DHaP02
5:D00aS65:DDY@0:5:D011245:DDYA243ABU000I=Jd07CW>=Jde[CF]>Lhe[CW>=JdicSF]>Lhe[CW>
=JdicSF]>Lh`=3PF=1Dh5S@E>1Hd5A`DIa`L53@E>1D043@E00Ph5S@E>1Hh5Cag?9M967=N0WNm0W=l
00]eCgYFOom_>WB8NaUh2G/IMke_FgNm009cO003MkecO7Nm009cO004MkecO7=lMkd2Lg`01WNmLgac
O7NmLgag_@9cO00<MkecO7=lMkecO7NmLgag_G=lMkecO7Nm1G=l0WNm00=[FSW>=Jd053F]00DaS3F]
<H`e[C6<008e[@`aS004;F/aS36<;F/2<H`01bf;;F/]Jbe[<H`]Jc6<00T]J`03:D/]Jbe[008]J`8Y
B`8]J`049BT]JbU;;F/2:D/00be[9BTU:@029BT01Be[9BTU:Be[9BT00RU;0bDY00@YBbDY9BTYB`/U
:@0<8@PU:BDY9BTQ22DY8@PU:B4X9BTQ22DY1R4800<Lib488@P00R4800/Lib488@PLib487>LQ21cW
8@PLib4800lLi`046<HLiacW6<H37>L00aS67>LHaP0C6<H00aBU6<HDY@026<H00aBU6<HDY@0?5:D0
0a245:D@Q00<5:D001`e[@0?>Lhe[CW>=JdicSF]>Lhe[CW>=JdicSF]>Lhe[C0d00@d5@8`=00571AF
UcPF=1Dh5P08=1D2<3@4=1D02CBf<3@d5C0d=1Dh5Cag@9M96003Mkd02GIDM8QdR7E?Oomk6GB8N[Id
R002Lg`016mKMkecO7Nm0g=l00Ag_G=lLgag_@9cO004MkecO7=lMkd2Lg`00gNmLgag_@02Lg`00gNm
Lgag_@03Lg`6Mkd2Lg`01WNmLgacO7NmKe/icQ<e[@05<H`e[CF]<H`e[@0=<H`00be[<H`aS002<H`0
1Be[<H`]Jc6<;F/00S6<00<]Rbe[;F/032e[00d]RcVXOb1JIBe[9BTYBbe[9BT]JbDY:D/U:@02:D/2
;F/00bDY:D/YB`069BT00bU;9BTU:@0@9BT01B489BTU:B489BT04b4800@Lib487>LQ208Li`058@PL
ib487>LM200=7>L00aS67>LHaP026<H01ASW6<HLiaS67>L031S600PDYAS65:DHaQBU6<HDYAS60QBU
00<HaQBU6<H00QBU00<HaQBU6<H03ABU00<@Q1BU5:D02QBU000Z=Jd06C0dA=Pi]QPC=;I5fEGjMkeo
oaPC>1Dd5CPF=1DhMCPF=;HhMCbG?7M15e5JBAQ8nE5J0098n@9EnP0CGY``=3PE@9LlMdTHLeig_FmK
OomilGE;LgaoogZfN:ajEWB8Mkd00W=l00Qg_G=lLgag_G=lMkecO7Nm0W=l00Ag_G=lLgag_@9cO004
MkecO7=lMkd2Lg`00gNmLgacO002Lg`2Mkd017=lMkeg_GNm0Woo00=g_GooLg`00WNm00=W75JG=Jd0
3SF]00DaS3F]<Hde[C6<008e[@06<H`e[C6<=JdaS3F]236<00L]Jc6<<H`aS2e[<H`]J`03<H`00be[
<H`]J`0?;F/01BU;;F/iZ7lPFVD00RU;00T]JbDY:D/U:Be[IZ9=iRDY:D/00RDY00<]RfJR@LD00RU;
00@U:BU;9BTYB`8U:@03:D/U:BDY00`U:@0:8@PU:B489BTQ22DY8@PU:B489BT<8@P00acW8@PLi`04
8@P27>L00b487>LLi`0>7>L00aS67>LLi`047>L00aS67>LLi`0>6<H01D75FV8HaQS65:D00QS600@D
YAS65:DHaP<DY@036<HDYABU00XDY@0348@DYA2400hDY@0013F]00<aS3F]=Jd02SF]00<aS3F]=Jd0
1cF]00<aS3F]=Jd033F]00D`=44GMkeW77Nm009oo`0EGYaW71`D>1Hd5CagEOYNW55J@7QbgEjLA=Qb
gFLLGYa8nG;MGYaEnUjL009EnP05<3@h5Sag?;E96002Mkd2Lg`00e[gMkeg_@02Mkd01WP9L6=fE7oo
Ke]g_@9cO003MkecO7Nm00=cO005MkecO7=lLgag_@02Lg`017NmLgacO7Nm0W=l00Eg_G=lLgag_G=l
00=oo`08G_LmkcF]<H`]Jd8@JeYJeP9g_@03LehTSB3Y00He[@03<H`e[CF]00Le[@04<H`e[CF]=Jd2
<H`00c6=<H`aS009<H`00be[<H`aS002<H`012e[<H`]Jc6<4be[00XYBbe[:D/YBcVXOb1JIBU;;F/U
:@8]J`8YB`09IZ9Va2DY:D/U:BU;9BUVXVK4008U:@03:D/U:BDY00HU:@037BTU:BDY008U:@037BTU
:BDY008U:@0<8@PU:B4X7BTQ224X7BTU:B488BPQ224X124800<M22488@P02B4811cW0Qd800<Q21cW
7>L00acW00<HiaS67>L011cW0aSW00DM21cW6>LHaQSW008HaP056>LHaQBU6<HHi`0:6<H021C55:Da
@glP<D<HaQBU6<H25:D01QS65:DDYAS65:DHaQ4DY@0348@DYABU00XDY@0000<aS3F]<H`00cF]00Xa
SCF]=JdaS3F]<H`e[C6<=JdaS08e[@04<H`e[CF]<H`2=Jd00c6<=Jde[@0?=Jd02BPa=;IoogNmEOXd
]S0d315>6@02=1D0130d@7QNW4hI0TSi00A964CH@7Ph5P<lM`03=;Hd5CPF008`=008=1Dh5CPE?7M0
UdTHLeig_@9cO008Ke]F]DYBG_M[FW=lG_Mg_@9_F`03MkecO7Nm00=cO008MkecO7NmLgag_G=lMkec
O09g_@9cO005MkecO7=lMkecO002Mkd05W=lMke_Fa24@Q1cO4icAS5242e[CW<icQ24JeYoog=l=;H<
336=<H`e[C6<0cF]00XaS3F]<H`e[C6<=JdaS3F]<H`e[@<aS003=JdaS36<00daS00:;F/aS2e[<H`]
Jc6<;F/aS2e[<H`7;F/06eYUIZ8]JfJRFVD]JeYUIZ8YBbe[FVE^`BU;@LEo86K4K/5JIBU;>JQ^`D75
:D]=iWlP>JPYB`029BT012U;@LEo83VX0bDY00PYBbDYERAVXQdY>JQVXTgV0bDY01=F96JR9BTaPfJR
@LDU:B4X8>UF96JR8>TaPfJR@LDQ25HTK/4]A`028@P02FJRER@Q2475IZ8]Ab487>M1a@02K/402be7
7>MF96JR7@Q1aFJR<D<LifJRER@00QcW00L]AfJRERAVXUHT;JAVXP02@LD01FJR<D=>8FJR6<H00VJR
0QcW01Q>8GlP@LDHidhQOb1JHQcW6<IVXThQ;DMVXT75<H=VXRe76<I^`EYR5:DHaQBU6<H35:D00aS6
5:DDY@025:D00aC55:DDY@095:D00a245:D@Q00>5:D000<e[@07<H`e[C6<=JdaS3F]<H`00SF]00Da
S3F]=Jde[C6<008e[@04<H`e[CF]<H`2=Jd0136=<H`e[C6<33F]00HaS30d@AMNW0`A61<2>1D03a`D
OolD5S@E>1Hd5C0d:9@X<BdE61<]5C0d=1D`=007=1D01SPE>1Hh5Cag?9M960=g_@06Ke]cO7ooLga[
FV<H0U[g00Uoof]JMkecO7NmLgag_G=lMkd00W=l00Ag_G=lLgag_@AcO004MkecO7=lMkd6Lg`01GNm
BU8@Q0@QHaP017oo00ag_Bf;6<I_FgNmLehX<A08<H`e[C6<=Jd2<H`:=Jd00c6<=JdaS00<<H`00be[
<H`]J`03<H`01Re[<H`]Jc6<;F/]R`X]J`0@I/Ao82e[Ob1Va2e[I/Ao82U;;F]VXWlP;F/iZ7lPK/42
Ob002SVXIZ9o86939BTYBfk1FVDU:BU;0RDY00DYBfk1ER@U:BU;00<U:@9o8007>JQF97lPIZ8U:B4X
7BT00WlP00LiZ4gVOb1VXRDY8BPQ2002Ob002SVXCNIo86JR8@Q^`GlP@LDQ22e70WlP01@PjFJROb1F
91cW;DMo86k1Ob1^`Ad8K/5o81d8CR5o83VX7>Mo86JR0QcW00iJHWlPK/5o86JR=BMo84G1CR5o83DW
IZ9o82e70WlP01/M9475Ob1o84G1@LEo86k1Ob1JHQS6Ob1VXS53Ob15`DgVOb0a@aC5<H=o81cW5:DH
aQBU6<H00aBU00<HaQBU6<H041BU0Q2431BU0003<H`01CF]<H`e[C6<=Jd0136<00De[C6<<H`aS3F]
008aS004=JdaS36<=Jd2<H`00cF]<H`aS002=Jd01c6<=JdaS3F]<H`e[C6<008e[@07<H`e[CF]<3@l
Uc4f=1D00SPF00<L56LLEOX00c@E00X`=7=NOomAFWoo@AMooeGj71@h5P8h5@0<>1Hh5C@E>1Hh5CPF
=1DhMD2G?7M967=N0gNm00U[FW=lOomg_GooMke_>VmKLg`00WNm00IcO7NmLgag_G=lMkd3Lg`01GNm
Lgag_G=lMkd00W=l00ig_G=lLgag_G=lMkecO7NmLgaoodYB36<48F<H0U[F00IS67NmMke2436<Lg`2
Mkd01dYg?Nle[C6<=JdaS3F]01PaS003;F/aS36<00<aS08]J`03<H`]Rc6<00/]J`0::D/]Jfk1Ob0]
JglPK/4YBfk1Ob02;F/036JROb0YBcVXOb1RAT75Ob1F92DYCNH]R`8U:@03ERA^`BU;008U:@05:D/U
:EHTOb0M:@039BT01CVXOb1o85HTIZ800WlP0RDY00DiZ7lPOb1F96JR009o80037BTQ:3VX009o8007
ERAVXWlPOb0Q22e7@LD00R4800AF97lPOb0aP`9o800AIZ8LidgVOb11aEHTOb0]AfJROb0M25HTOb0]
Y1cWOb1VXP027>L07glPK/4LiglPIZ8aPglPERA=iWlP<D=VXWlP6<Ha@c636>MJHWlP;DLHaUYROb0L
ifk1Ob0DYGlPIZ8a@glP009>8@0;Ob0a@aS67>Mo84G16<HDYAS65:DHaP0A5:D00a245:D@Q0035:D0
0a245:DDY@095:D001`aS00F=JdaS3F]<H`e[C6<=JdaS3F]<H`e[C6<=JdaS30d@AM>6APC71@d5C0d
?AL2=1D02cPF=1Dd5D4GG_QEnRdEL]eNW7;M:3400SPF00@d5CPE=1Dh5P<d5@05>1Dh5Sag?;E96002
Mkd3Lg`016]JKcYcO7Nm0VmK00=cO7NmLg`01g=l00=g_G=lMkd00g=l00Ag_G=lLgag_@9cO003Mkec
O7Nm00=cO09g_@0@Ke/<HbU;MkdDYB489BTaS7NmDY@e[FmKMkecO7ooHaPL<H`02Be[<H`aS2e[<H`]
Jbf;;F/aS00@;F/056JROb0YBglPIZ8]JfJROb0YBbDYI/Ao82U;@LEo8475>JQo85YU:D/39BT01RU;
>JQo84gV9BTYB`8U:@03;F]o84gV00<U:@0;FVEo86JRIZ9o8693Ob11aAdYERAo8002IZ801glPHT=o
84758>UF97lP009VXP05Ob1R@glP@LDM20038@P3K/4056JROb1JHWlP8@QF97lP<H=F97lP<H=VXWlP
7>M>8GlP=BLLiglPK/427>L00glPIZ8Li`02K/402SDWOb1>8DhQOb0a@fJROb0HaQcW0QS601M^`GlP
6<HHaVk1Ob0HaVJROb0DYGlPIZ8a@glPCNI5`GlP<D<HiaBUERA^`AS600DDY@036<HDYAS6014DY@8@
Q0HDY@0348@DYABU00<DY@00:S6<00/`=3BfOomg_DhI@AL`=0`A=1Dh5CPF008d5@09=;Ig_CBf611c
GUGjLehXU3PE008d5@0<>1Hd5CPE=1Dh5SPE>1Hh5D2G?9M967=N1Goo0WNm00=_FgNmMkd027Nm00Qc
O7NmLgag_G=lMkecO7Nm17=l0WNm00IcO7NmLgag_G=lMkd2Lg`047NmKe]g_GNm<H`e[C6<;H]g_Dic
@Q1cO7NmLgag_F<H5S6<00D]Jc6<;F/aS2e[008aS008;F/aS2e[<H`]Jc6<;F/]R`h]J`0::D/]JfK4
Ob0YBglPIZ8YBfJROb02:D/036JROb0YBcVXOb1JIDgVOb1=iRDYCNH]J`<U:@03IZ9Va2DY00@U:@9V
XP03:D/U:B4X009^`@07CNIo87lP@LEo85YU9BT00Vk100M1aGlPOb11aGlPHT<M:@02K/402d75Ob1o
8475Ob1F91d88@PLib4XOb000UYR0WlP01]1aGlP@LE1aGlP@LEF97lP;DMVXWlP7>MF97lP<H<LiglP
K/4LiaSWOb1^`AcWOb1VXS63Ob000UHT00Ao82fTK/5o808HaP0D7>LHaUYROb0M91cWFV9o81S6K/5o
81S6Ob1^`C63Ob1>8EHTOb0a@`8DY@03<D=o835300<DY@036<HDYABU00hDY@0548@DYA245:D@Q002
5:D00a245:DDY@045:D00a245:DDY@025:D002XaS004:34m5gNmG_P3Ool047=lIa`d5C@E>1H`=3Qe
Lei961PCL]eNW7;M61<h5SPE0S@E00Dh5S@E=1Dh5C@E008h5@8lM`07DEYBU4HaBU9>Le:DF]H00Ukg
0V<H0V]J00=_Fg=lIa`00WNm1goo00=g_GooOol00goo27Nm00=cO7NmMkd01GNm00=oogNmOol017Nm
00AcO7NmMkeFU`8aS003;F/aS36<01HaS006;F/aS36<;F/aS2f;32e[00DYBbe[:D/]JbU;008]J`07
:D]^`GlPK/5o86K4>JP00WlP00IJICVXOb1o85HT@LD4Ob002SVXFV9o85YU9BTYBbDY@LEo83VX12DY
00Q1aGlP;DLQ:2e[Ob1R@cDW0WlP00LQ:6k1K/4]AglPHT<e9`02Ob001b4XK/5^`Be7Ob1R@be7009o
80038@Q^`GlP008Q200G7@Q1aGlP@LE=iWlPIZ8]AglPFV8]AglPK/5o86k17>MVXWlP;DM^`GlPK/4L
i`02Ob0026k1;DMVXWlPK/5o86JR<D<7Ob003QcW6<HHaQS6@LEo86JR<H=1aGlPK/5o85YR6<H7Ob00
23536<HHaQBUK/5JHQBU6<H35:D00aS65:DDY@0=5:D01a245:D@Q1BU48@DYA2400/DY@00236<0Re[
4C6<00<]Jc6<<H`0336<01T`=4Si?AL<4DhI7C9:MgooCQTd5CPF=1D`=7NmL]dm5aPCCQUoodGI<3@h
5S@E>1Hd5@02>1D02SPF=1Dh5CPF>1DlMd2GDEXU:@aS0P@Q0P000PaS0QcR00@DaB4848@@R@8IJ`08
6FhN3c8`=O0fECG`AS56D`A6f005G_QS66<HKe]W7003Mkd:Ool00gNmOomg_@05Mkd00g=N?ALXU00E
<H`012e[<H`]Jc6<0Re[00@aS2e[;F/]R`d]J`03:D/]Jbe[00<]J`09:D/U:Be[IZ9o85HTOb1=iSVX
009o800>FVDiZ7lPOb1JICVXIZ9F96JRFVDU:DgVK/5=iP@U:@03K/5F92DY00@U:@0SK/5F92DY@LEV
XT759BUVXUHT9BUF96JR@LEVXT758>UVXUHT8@QF96JR@LEVXT758@QVXUHT8@QF96JR8BPLib48ERAV
XP02;DL01fk1@LDQ26JRHT<Lid75009^`@0J;DLLifJROb0]Afk1Ob1^`AcWIZ9F95YR<H<]AfJRCR5V
XUHT;DMVXTG1IZ9^`C53K/5F90DHaP0BERAo84G16<I>8GlPFV8LiaC5IZ9>8EHTOb0aPfJRK/4DYAS6
0QBU00<aPglP6<H04QBU00P@Q1BU5:D@Q1BU48@DYA241ABU00<@Q1BU48@011BU0000236<;F/aS2e[
<H`]Jc6<;F/3<H`03Be[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[008aS003;F/aS36<00daS00@<3@L
51`D51I15c4fIa`i]QPC>1Hd5CPE<3@m5dTH:342<3@0234f:34h5S@E>1Dd5CPE>1H3=1D02SPF=1Dh
5T2G?9MAFRe[48@Da@dT0Q240QC500@DYAC55<DX@`848@0534P8i`a81>X8i`021>X01@S634P4jP5^
1</00`5^00H9BQd86>LAJ1U[6Fh2<H`03Ah?=O0b<1U^EDaA<THa=a1BU7XCMUANn6]J009cO09oo`03
Mkdd]QPC008aS00D;F/aS2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS08]J`03<H`]
Jc6<00X]J`03:D/]Jbe[00<]J`07:D/]Jbe[:D/U:Be[9BT00be[00aVXWlP:D/YBbe[9BUVXWlP:D/U
:FJROb02:D/00bDY:D/U:@039BT00bU;9BTU:@039BT00eYUOb0M:@049BT045HTOb0M:BDY8BPU:B48
9BTQ22DY8@PU:B489BTQ:2DY324800<Lib488@P00R4800DLib488@PLib48008Li`038@PLib4800DL
i`06IZ9o81cWCR5o83DW1AcW00THaQcW7>LHaQcW6<HLiaS67>L00QS600<HiaS66<H02aS600@DYAS6
6<HHaP8DY@036<HDYAS600<DY@046<HLiglPAL4@5:D01Q245:DDYABU48@DY@8@Q0035:D@Q1BU00<D
Y@0348@DYABU00@DY@4@Q00000T]Jc6<;F/aS2e[<H`]Jc6<;H/00Re[01`aS2e[<H`]Jc6<;F/aS2e[
<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`]J`8aS007;H/`=41h=;H<4G=lEOX0
0S0d00dh5C@E>1Hd5CPF@7PlMd1hA=Q0N3bGB?Th5P02=1D03SPF=1Dd5CPE>1Hh5C@E>1DhMCag@9MA
FRe[3B@348@050dT48@M91cR7>L8i`S5?00X@`SW1>X8i`dX1FX4b`SW1>X9BQU[0Fh20Hh30Fh01A3Z
2>L=:0dX1FX00a5X02`1SPSW34P=90SU1>X@Q0`748@X@`dT0L@D25QR48U<PRS3=1Dh5S6<;F/aS2e[
<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`]Jc6<;F/aS2e[<H`]Jbf;3Be[00@YBbe[;F/YB`8]J`04
:D/]Jbe[:D/2;F/01RU;9BTYBfJROb0YB`8U:@07:D]=iUHT:D/U:DgVFVD012DY00<YBbDY:D/01bDY
00<]AglPCNH012DY00D]AglPCNHU:B4800<U:@8Q20039BTQ2248014Q20047>LQ21cW8@P27>L01248
7>LLib4821cW00IVXWlP6>MF97lP<H<27>L00aS67>LLi`027>L011S67>LHaQcW0aS600<LiaS66<H0
3QS600<DYAS65:D00QS600<DYAS65:D00QS60aBU00=JHVk15:D041BU00D@Q1BU48@DYA24008DY@03
48@DYA2400@DY@0348@DYA2400@DY@005Re[00@]Rbe[;F/]R`8]J``aS008;F/aS30d@AMW77;M@ALH
4`8h5P0==;Hh5SPE=1Dh5TGIB?U15dTH?7M4f4TH>1H00S@E00<h5CPF=1D00S@E00Ph5SPE>1Hh5Cag
@9MAFRU;0Q240PaS01@@Q1cR5<DDa@S548@<1`a8:4<8i`CZ2<H4jPC;1>X8iadY8BPLhQ5X0P5^0`6>
01/4b`U:1FXIJ`U:6F/9BP6>2DY80BQ30LL1YQ29>8L4b`6V0RHDYCR70A5HHRSX0NhM<SP_98d022e[
00<]Rbe[;F/00be[00D]Rbe[;F/]Jbf;008]J`03;H/]Jbe[00/]J`03:D/]Jbe[008]J`06:D/]Jbe[
:D/]JbDY0Re[00lU:BU;;F/YBbe[IZ9o82e[:D/U:BU;9BTYBbDY:D/00RDY00<YBbDY:D/032DY00=R
@fJR9BT012DY00AR@fJR7BTU:@8Q20059BTQ22DY8@PM:@0=8@P011cW8@PQ21cW0R4800<Lib487>L0
0R4800<Lib487>L02AcW00MVXWlP7>M5`GlPK/4HaP027>L00aS67>LHaP027>L00aS67>LHaP027>L=
6<H011BU6<HHaQBU0QS600HDYAS65:DHaQBU6<H35:D01QS65:DDYAdTOb0a@`hDY@0<48@DYABU48@D
YA245:D@Q1BU48@DYA240QBU00@@Q1BU5:D@Q0@DY@4@Q0007Be[00@]Rbe[;F/]R`8]J`0D;H/]Jbf;
;F/]Rbe[<H`X<D4GLehXU1`D=1DL51P@EOX`=3PF=1Dh5PHd5@04<3@d5C@E>1H2=1D00cPE>1Hh5@03
=1D01CPE?7M0Ue5J;F/00Q2400<=90aS2<D00PaS00L8a@S648@l00@Q2<H=90032>L02@U:7@P9BQU^
4FP8iAdT1FX1KP030Hh01PU:1</9BPC;2DX5JP81KP0C1</XQbR76<HAJ0CZ>6<PRa5X0LLXQf044>XI
KRPa7C84bbI70RH09Be[0RU;010]JbU;;F/U:Be[:D/]JbU;9BT]JbU;9BT]JbDYFVE^`@8U:@07;F/U
:BU;9BTYBbDY:D/01BDY00<YBbDY9BT022DY00=1aFJR;DL00bDY00LQ2475IZ8]Ab3Y8BPU:@0@8@P0
2QcW8@PQ22487>LQ21cW8@PLib481AcW00<M21cW7>L01acW00aF96JR6<H]AfJROb0HiacW6<HLiaS6
7>L26<H00acW6<HLi`0D6<H02QBU6<HDYAS65:DHaQBU6<HDYAS611BU00=JHTG15:D03aBU00P@Q1BU
48@DYA245:D@Q1BU0Q2400LDYA245:DDYA245:D@Q0025:D148@15:D002X]J`0=:358nCIE314L53bG
?AM5fG=N71@d5CPE>1H00c@E00Xh5C@E>1Dh5S@E>1Hh5C@E>1Dh5P<d5@07>1Hh5CPF?7LlUe5J;F/0
0Q240`aS0`S500<DY@aS:4<00RQ300T8a@S62>L@jQU[6Fh1KQU^6<H00PdT01H9BP6>0Hh1KP6>1</9
BPEZ2DX1KPU:0NhhQbQ31FX1a3QSB04<B0T73B@h3084b`06>6<h;`FB2DYD1@C;0P8V7Re[00DYBbe[
:D/]JbDY008]J`04:D/]Jbe[;F/2:D/012e[9BTYBbDY0Re[00@U:Be[9BTYB`8U:@8YB`039BTYBbDY
00HU:@03:D/U:BDY00XU:@038BPU:BDY008Q20049BTQ22DY9BT38@P00bDY8@PQ200=8@P041cW8@PQ
22487>LQ21cW8@PLib487>LQ21cW8@PLib484QcW00DHaQcW6<HLiaS6008Lia4HaP045:DHaQBU6<H2
5:D01AS65:DHaQBU6<H061BU00X@Q1BU48@DYA245:D@Q1BU48@DY@8@Q0@DY@0348@DYA24008DY@4@
Q04DY@4DY@00:Re[00@`=3dGMkeg_@9oo`05LeioogNm61<h5P02>1D01C@E>1Hd5C@E>1H00S@E00@h
5C@E=1Dh5P<d5@09>1Hh5C@E>1HhMCag@9MAFRU;008@Q0092<D<H`S536<@Q0S55:D<H`a8008@Q00[
5:D9BPU:2DX@jPU:3BP9BQ5X3BP=915X0Fh4jPSW3BP@jQ291FX9BP5^0Nh4bbQ3E0DHi`6V4>Y80D@7
0JH91bR7B04TS@4A9<]<PPC;>6<a@db6:8L03Be[00<YBbe[;F/02Re[00<YBbe[:D/01Be[0RU;0Re[
00LU:BU;9BT]JbDY:D/]J`02:D/29BT012U;9BTYBbDY0RU;1BDY00DYBbDY:D/U:BU;00/U:@058@PU
:BDY9BTQ:0039BT00b489BTQ:0028@P00bDY8@PQ200<8@P00acW8@PQ20028@P011cW8@PLib480QcW
00<Q21cW7>L041cW00`HaQcW6<HLiaS67>LHaQcW6<HLiaS67>L36<H00aSW6<HHaP0;6<H00aBU6<HH
aP026<H02aBU6<HHaQBU6<HDYAS65:DHaQBU6<H04aBU00L@Q1BU5:D@Q1BU48@DY@0648@011BU48@D
YA240QBU00<@Q1BU48@00aBU0A2400000be[:D/]J`06;F/012U;;F/]JbU;12e[0RU;22e[00<YBbe[
;F/032e[02HX<CBfOomNW4Yg<CHm5fLL?ALd5CPE>1Hd5CPF>1Dd5CPF>1Dh5S@E>1Hh5C@E>1Dh5S@E
>1Hd5CPE=1Dh5SPE?7M0Ue5J;F/@Q0dT0`aS0PS501L8aQ2436<HaQ291FX9BQ3Z3BP9BQ5X3BP9BPdX
4FP=90T74FPDYBQ3:8LX@bR700<9BP080Hh9BRQ31>XM90dT:<<el096<@0=DSA>=3UA:8L=:1cR0A4I
KRB=0NhTbdP;>0`01Re[00@YBbe[;F/YB`L]J`04:D/]JbU;:D/9;F/00bU;;F/U:@03;F/042DY:D/]
JbU;;F/U:Be[9BTYBbDY;F/YBbDY:D/U:BU;0bDY00DYBbDY:D/U:BU;018U:@048@PU:B3Y9BT28@P0
1BDY8@PU:B487BT04B4800PLib487>LQ21cW7@PLib480QcW00<Q21cW7@P051cW00DHaQcW6<HHaQcW
008HaP037>LHaQS600lHaP035:DHaQBU008HaP045:DHaQBU6<H35:D00aC55:DDY@0D5:D00a245:D@
Q0025:D00a245:DDY@025:D548@021BU48@DYA245:D@Q1BU48@25:D000<]J`03:D/]JbDY00@]J`0:
:D/]Jbe[;F/YBbe[:D/]Jbe7;F/2:D/01Be[9BT]Jbe[:D/02be[00LYBbe[;F/]JbPaDEYFU`023140
1TYgIa`d]QPC>1Hh5@8d5@04>1Dd5CPF>1D2=1D013PE=1Dd5CPF0c@E00@h5C@E>1Hd5@8h5@04?9M0
Ue5J:D/248@236<00`S536<8a@025:D01@SW4>X=:0SW4>X010dX00<5JPdX2DX00Q5X00h91bQ3:4<X
@a24:4<DYAS62>L1KP6>3BPhHbQ30P7701PhHdQ<4>X1aadYABPM<P6V6<I80@`72<HXj1db:9@H4cPC
:D/]JbDY;F/YBbe[:D/4;F/022U;;F/]JbU;;F/U:Be[:D/3;F/012U;9BT]Rbe[0RU;00D]JbDY;F/U
:Be[008YB`0;9BTYBbU;9BTYBbDY;F/U:Be[9BT]J`029BT00be[9BTYB`029BT00bU;9BTU:@0A9BT2
8@P01RDY8@PQ22DY8@PU:@8Q:0039BTQ2248010Q20087>LQ22488@PLib487@PLi`8Q20<Li`037@PL
iacW010Li`046<HLiaS67>L26<H01AcW6<HLiaS67>L051S600<DYAS65:D00QBU00HHaQBU5:DHaQBU
6<HC5:D011245:DDYA240aBU0Q2400<DYA2448@00a2400`DYA2448@DYA245:D@Q1BU48@DYA245:D2
48@0000D:D/U:BU;;F/YBbe[:D/U:Be[9BT]JbDY;F/YBbe[:D/]JbU;;F/U:@<]J`07:D/]JbDY;F/Y
Bbe[:D/00be[00<YBbe[:D/01Be[00<YBc0d@7P00QPC00]bgDGI:9@`=3PF=1Dh5SPE>1Hd5CPF00<d
5@0:>1Hd5C@E>1Hd5CPF>1Dh5S@E>1H2=1D2>1H04Cag@9MAFRe[48@=90aS2<D<H`S548@8aPCZ2@L=
:13Z2@L010dX00HIJa5X3BP5JQ5X3BP2:4<07aBU6>L@RBS3:8LLibQ32DXDaA2448TX@aSW6<H=93g_
CS@e[CG@AO=1;D8@=UE>4UgbDY@M:DP10LLM<SPC008YB`09;F/YBbe[9BT]JbDY;F/U:BU;008]J`04
9BT]Jbe[:D/3;F/01RU;9BT]Jbe[:D/U:@8]J`8YB`0?;F/YBbe[9BT]JbDY;F/U:Be[9BT]JbDY:D/U
:BU;008U:@03:D/U:BDY008U:@04:D/U:BDY:D/?9BT012489BTU:BDY0R4800LU:B488@PU:B488>TQ
:00<8@P01QcW8@PQ21cW8@PLi`8Q20<Li`038@PLiacW00<Li`038@PLiacW00XLi`036<HLiacW008L
i`0<6<HLiaS67>LHaQcW6<HLiaS67>LHaQSW3aS600@DYAS65:DHaP8DY@046<HDYAS65:D36<H00aBU
6<HDY@0D5:D01A245:DDYA245:D011240QBU00@@Q1BU48@DY@<@Q00:5:D@Q1BU48@DYA245:D@Q1BU
48@25:D0000A;F/YBbe[9BT]JbDY;F/YBbDY;F/YBbe[9BT]JbDY;F/U:@02:D/01Be[9BTYBbDY;F/0
0RU;00DU:Be[;F/]JbDY00<YB`<]J`0=9BT]JbU;:D/]Jc0d:34]5Goo;AD<4A`D<3@00c@E0SPE00Xd
5CPE=1Dh5SPE=1Dh5SPE=1Dh5@8d5@0;>1Dd5CPE=1Dh5SPE>7DlMd2GDEXYB`0248@236<00`S548@8
a@032>L22@L02QSW2@L91`dX2DY5:3QS1FXAJ0EZ0QBU01HQ22Q3:8LXQbS3:8LDYAcW>6<R0DP1:8L1
a`T7B04hHaU^6F/lk2B=2DXAJ08hQ`0?6F/N3db666TAJ3QS>2ld5Be[9BT]JbDY;F/YBbe[008YB`8]
J`0:9BTYBbU;;F/U:Be[9BTYBbDY;F/2:D/02BDY;F/YBbe[9BT]JbDY:D/U:@02:D/02RDY;F/U:BU;
9BTYBbDY:D/U:BU;0RDY00DYBbDY9BTU:BU;014U:@038@PU:BDY008Q:08Q20059BTQ:2489BTQ:00D
8@P021cW8@PQ21cW8@PM22487>L28@P00acW8@PLi`0>7>L02aS67>LHaQSW7>LHaQcW6<HLiaS67>L0
5AS600<DYAS65:D00aS600@DYAS65:DDaAXDY@0448@DYABU48@45:D:48@25:D00a245:D@Q00248@2
5:D248@000039BT]JbDY008YB`099BT]Jbe[9BTYBbDY:D/]JbDY008YB`05;F/U:Be[9BTYB`02;F/0
12DY;F/]Jbe[0RDY00<YBbe[;F/00Re[00DU:Be[9BT]JbU;008]J`049BT`=3BfLeh3Ool01EGjBAPd
]SPE>1H00S@E00<h5S@E>1D00S@E00Hh5SPE=1Dh5S@E>1H2=1D01SPF=1Dd5CPE=1Dh5@90U`0=DEXY
Ba2448@8a@aS2<D@Q0S62>L91aS62@L00PSW00H91`dX3BP5JTDXIBL21FX01@dX:4<XQaS6:8L00RQ3
01`DYCQS7@P@RBQ3<D<M92Q36<H8iaQYC89244Yg=M1>LT8@=O15ld8@E[DQ:0@Q>6<=:2R79</14@<Y
B`05;F/U:Be[9BT]J`029BT3:D/012DY:D/]JbDY0bU;00LU:Be[:D/]JbDY;F/U:@02:D/02Re[:D/Y
BbDY;F/YBbDY:D/U:BU;0bDY00<YBbDY:D/00bDY00<YBbDY9BT02bDY00DQ22DY8@PU:B4800@U:@04
8>TU:B487BTB8@P00acW8@PQ20027>L00b487>LM200J7>L00aSW7>LLi`026<H01acW6<HLiaS67>LH
aQcW018HaP055:DHaQS65:DHaP025:D00aS65<DHaP0E5:D01A245:DDYABU48@00aBU00<@Q1BU48@0
0a240QBU00@@Q1BU48@DY@H@Q0055:D@Q1BU48@DY@0248@25:D148@00006:D/U:BU;9BT]JbU;0RDY
00<YBbDY:D/00RDY00P]JbDY:D/U:Be[9BTYBbe[0RDY00XYBbDY9BTU:Be[:D/]JbDY;F/U:@8YB`07
;F/YBbU;:D/U:Be[:D/00S0d00@XU2fhCQUEnP9oo`0=MkdL53PF>1Dh5S@E>1Hd5CPF=1Dh5C@E>1H0
0S@E0SPE00dh5S@E>1Dh5S@E>1Dh5Sag?9MAFRe[48@8a@0236<248@00`S62>L8i`022<H52@L01P7^
=BMe91U[3BPHaP8X@`0F48@X`cQS:8LDYBS3>6<=:1S6>6<R0@dX>6<Li`774L@D23c/6FhIJcc/>8L2
2DX02Ug>A0L1KPU:B041KP7^0LLU:BU;0RDY00TYBbDY:D/U:Be[:D/U:BU;;DL00RU;00@U:BU;:D/]
A`8YB`8U:@06:D/U:BU;:D/U:Be[0RDY00X]AbU;9BTU:BU;9BTicU:D>LhYB`DU:@03CW96<D8@00PU
:@03=Je:DT8@00I24003AS4e[BDY00/Q2005@Q1JeUJeE[E2400:8@P011cW8@PU:D8@23g_00=241cW
7>L01QcW00=>LdHa8BP01QcW0QS600TLiaS66<HLicg_AS4aS1S67>L01AS600<Q248@?Nl01QS600<a
S48@@Q000aS600<DaAS65:D00QS600<DYAS66<H00aBU00<HaT8@DY@00Tic00=BU36<5:D02QBU00H@
Q2U;@Q0aS1BU48@35:D01a245:D@Q1BU9BU2436<00`@Q0045:D@Q1245:D348@00aBU48@@Q00148@0
00049BTYBbDY:D/29BT2:D/00bDY:D/U:@02:D/01bDY:D/U:BDY:D/U:BU;008U:@8YB`099BTYBbU;
:D/U:BU;9BT]JbDY008]J`8U:@08;F/U:Be[:D/U:C0d=1DL508<4@05AMUW74hIIa`L5002=1D033PE
=1Dh5C@E>1Dh5S@E>1Hh5CPF=1Dh5P8d5@0:>1Hd5C@E=1Dh5SQe?7M0Ue5J;F/248@01PaS2<D8a@S5
2<H8i`88aPH91`0X0NhU:Gg<ABP1abQ37>LPjBQ3:>Q>02SX5:DX@dG17B@@RC53;J@aPaBU:8L=:1C5
AO=244ic>E4mCD8@?Nm5lcUAAO=N53G@4>Xlk22;30`2:D/01bDY:D/YBbDY:D/U:BU;008U:@03:D/U
:BU;008U:@04:D/U:BDY:D/29BT2:D/012DY:D/U:BU;0RDY0bU;00LU:BU;9BTU:F<HOomS60029BT0
12U;9BTU:FmK0Woo00<icRDY9BT01RDY00=S67ooOol01goo00AS62488@PU:@LQ2003?Nmoogoo00Eo
o`03:D/Q21cW008Q208Li`058@PLib488@Pe[@0:Ool87>L2Ool00g=l6>LLi`027>L26<H37>L00aS6
7>Le[@02Ool00dic6<HHaP056<H00cg_Oomoo`056<H012e[OomoogNm0QS600@DYAS65:DHaP8DY@03
5<DHaQBU008DY@03Ke]oogoo00Ioo`03DY@DYABU00HDY@0348@DYF<H009oo`0348@DYABU008@Q005
5:D@Q1BU48AS6002Ool348@00aBU48@@Q00848@00aBU48@@Q00248@00aBU48@@Q0015:D00003:D/U
:BDY008U:@03:D/U:BDY008U:@03:D/U:BDY008U:@04:D/U:BDY:D/29BT00bU;9BTU:@049BT01Be[
9BTYBbDY:D/00RDY0RU;01DU:BU;9BTU:BU;:358nEJG?AMcO5jL<3@H4dGI>1Hd5CPF=1Dh5S@E>1H0
0S@E00@h5C@E=1Dh5@8d5@06>1Hh5C@E=1Dh5SPE0SPF00LlMd2GDEXYBaBU2<D<H`0248@22<D00`S6
2>L8i@022<H32@L0:@dX1I8hHgDTMD/e9`aS:>PIKRQ37>M<QSR7:<<XQcQS:<<=:2R78P5>01S6>6<X
@b3Y4FPX@cQS5:D1a1cWB04XQ`6V2DXhHd@70A4XQd@7>0`00RDY00<YBbDY9BT00RDY00@YBbDY9BTY
B`@U:@04:D/U:BDY:D/29BT00bU;9BTU:@049BT00bU;9BTU:@049BT01BU;9BUJeWooG_L012DY00A2
47ooOomF]@HU:@048@PU:B48G_L9Ool00ekg9BTQ:0078@P01c6<OomoogooKcYJeWNm00=oo`049BTQ
22487>L28@P01AcW8@PLiacW=Jd02Woo21cW00LicWooOolLiaS67>LHaP027>L36<H00acW6<IcO002
Ool86<H00cF]Oomoo`056<H3Ool011S65:DHaQBU0QS600@DYAS65:DHaP8DY@03>Lioogoo009oo`04
Lga>Lf<HMkd3Ool00fmK5:DDY@035:D01a245:DDYA24F]IoogNm008DY@0548@DYABU48@DY@0248@0
1E[FOomg_A245:D02Q2400DDYA2448@@Q1BU008@Q0035:D@Q124004@Q00000@U:BU;9BTYB`8U:@03
:D/U:BU;008U:@03:D/U:BU;008U:@04:D/U:BDY:D/29BT01BU;9BTYBbDY:D/00RDY00DYBbDY:D/U
:BU;00<U:@0>:D/U:BU;:D/U:C0d?AMg_DYg=1DL53PE=1DH4`8h5P06>1Dd5CPE=1Dh5CPF0S@E00@h
5S@E>1Hh5@8d5@05>1Hd5CPF>1Dd5@02>1D023ag@9MAFRe[2<D@Q0S536<32<D32<H22@L02`SW2@L9
1a5X3O`lk7DTH:Qmc2Q348@00QBU00A5:7B8C8HLi`8X``0I:8LLhQS6<D<R0DG1>6<HJA5X2>LX@c`0
2>D1YPa8>6<<H`7434PD213ZC881KRPa>1D00bDY00<YBbDY:D/00RDY00HYBbDY9BTYBbDY:D/29BT0
12U;9BTU:BU;0RDY00DYBbDY:D/U:BU;008U:@05:D/U:BU;9BTYB`039BT00e[FOomNm`049BT2Ool0
0gNm9BTU:@089BT00ekgOom_F`029BT01B489BTU:B488BP02R480goo0b4800<LibDYOol00Woo00XL
ib487>LLib487>LM22487>LaS09oo`hLi`036>LLiaS6009oo`05HaPLiaS67>LHaP027>L011SW7>LH
aQcW0Woo00=JeQS66<H01QS600Pe[GooOolHaQBU6<HDYF<H0Woo00<LiaBU6<H00QS600DDYAS65:DD
YAS6008DY@05@Q1oogooOolicP065:D00ekgOomcO0065:D01Q245:D@Q5JeOomg_@8@Q00:5:D@Q1BU
5:D@Q1BU48AF]GooLg`=48@00aBU48@@Q00448@15:D148@148@001`U:@07:D/U:BU;9BTYBbDY:D/0
0RDY00<YBbDY9BT00RDY00LX<CbG>KH]5C@E>1Dd5@02EOX01Q`D>1Dh5CPF=1Dh5P8d5@04>1Dh5S@E
>1D2=1D03CPF=1Dh5C@E>1Dd5CPF=1Dh5Cag@9MAFRU;008@Q00336<8a@S500<8a@@8aP891`092>DI
JdGI6OIe96DWMD]mc3R7009EC00OM8Qi:4@77>LX@cQS:<<e9adT8>Ta@b81<H<HJBS3>E4mkdE_<H`m
CCG`<H`el5E<?Dd]e1U^B04AJ1db@1@09BDY00=JeWooG_L00bDY0goo00DPjB4X9BTU:B4800@U:@8Q
2005F]IoogNm8@PQ:00>8@P01dYBOomoobDY8@PM21cW008Q2005;F]oogoo?NlLi`028@P00acW7@PL
i`027>L013F]Oomoob4841cW00MBU7ooOolHaQcW6<HLi`056<H00eJeOomoo`096<H00cF]Oomoo`03
6<H01SF]Oomooe:D5:DHaP<DY@045<DHaQBU6<H25:D0136<Oomoog=l2ABU00<mkfmK5:D00QBU0Q24
0aBU00P@Q5[FOomg_A245:D@Q1BU0Q2400HDYA2448AF]GooLg`G48@002@U:@0D:D/U:BDY9BTYBbDY
<3@d]WNmAMTL530d61=15goo61<h5CPF=1Dh5@8d5@04>1Hh5C@E>1D2=1D01cPF=1Dh5S@E>1Hd5CPF
008h5@07>1I0UcagDEX]J`S548@00PS50Q240PS500@8aQ5X4FP=:0891`0A3B@M<WXC1WmAkG1SMJMm
c7R/OLae97B8N:`XQaS6>6<X@`02:<<05acW7B@XQad88>TPRdP1=O0^CQU^GO95Ka5X7PlaSDE_=UEN
dBB=0L@Q:3P_=1D09BDY00IJeWooG_LU:B4XDY@2Ool01DHa9BTU:BDY8@P00RDY0b4800DQ:2DYG_Mo
ogNm00dQ20047>LQ2248BU82Ool02R487>LQ21cW8@PLib48Mkeoof<H21cW00@aS7ooOolQ20XLi`8H
aP057>LHaQcW6<HLi`02Ool00dYB6<HHaP066<H2Ool00f<H6<HHaP076<H01SF]OomooaBU6<HDa@9o
o`08MkdDYAS65:DDaAS65:DHaP8DY@035<DDYABU00=oo``DY@0348@DYA2400<DY@8@Q0045:EF]Goo
Mkd248@011BU48@DYABU0a2400=JeWooLg`05a2400099BT00b489BTU:@0N9BT0330d@AMNW0`AAMUN
W7;M315NW1@F=1Dh5@8d5@0>>1Hh5C@E=1Dh5S@E>1Hh5C@E>1Dd5CPE=1Dh5@8d5@08>1HhMCag@9MA
FRU;48@8a@8@Q0@8a@0F2<H9BRe7:>PIKQU[>6<]e1JM1am5KgDTOLadR7P9OLadR7g<MDlXj1S6:<<2
:8L06C535:DHiadY8>TaPa3Z7BTYBaU[98dmCCUA=M0YBcUA;ADYBdP15<D29R3Y>1<1Mb3Y02@U:@05
F]Iooekg9BTYB`02Ool02fmK9BTQ22DY8@PU:B4X8@PU:B487BT00R4800=JeWooMkd02b4800DLib48
8@PQ21cW008Q208Li`098@PLib487>LQ21cWKe]ooekg00PLi`04<Haoogoo8@P87>L02QS67>LLiacW
6<HLiaS67>LHaV]J37oo2QS600He[GooOolHaQC5Lg`2Ool011cW6<HDYAS621BU00A:DWooOolLi`TD
Y@0348@DYABU00<DY@0348@DYA24008DY@0848AF]GooMkd@Q1BU48@DY@D@Q003E[Eoog=l01L@Q000
2bDY00<M:BDY9BT072DY014X<DSiBWLH4eGjMkdXU0`ACQTh5S@E>1Dh5S@E>1Dd5CPF008d5@0;>1Hh
5C@E>1Hd5CPF=1Dh5S@E>1Hd5@02>1D013ag@9MAFRU;0Q2400<8a@aS2<D010S500/4jRe7D4a<QRC;
>8LiDC8i6OHFWF2X00=i:00QMD]dR7g<F68X@acW:>PX`bR7:<<hHbR7;J@M922;<D<R0BU;AO<ed3G`
AO=McU4bAU<^CQU^:4<HaSQS:341kRI700<U:@058BPU:BDY9BTQ:0069BT00b4X9BTQ:0039BT01248
9BTU:B481bDY00<Q22DY9BT00RDY00DQ25[FOomF]B4800=oo`079BTQ:2DY8BPU:B489BT01R4800=J
mgooMkd03B4800@Lib487>LLi`8Q20057>LQ21cW7>LQ20027>L2Ool00f<H7>LLi`067>L0136<Oomo
ob4811cW00<HiacW7>L00QcW00THaQcW6<HLiaS67>LHaQcW8@P02goo00=_FaS66<H011S600DDYAS6
6<HDYCF]009oo`0;5:DicWooOom241C56<HDYAS65:DHaP065:D00gNmOomcO00;5:D03Q245:D@Q1BU
48@DYA245:D@Q1BU48AF]GooMkd248@01ABU48@DYA245:D00Q2400=F]GooLg`05a2400001B489BTU
:BDY8@P00bDY00<Q22DY8@P00RDY00@Q22DY8>TQ:0@U:@8Q20059BTQ22DY8BPQ20049BT00b489BTU
:@039BT01b4X9BTU:B48:35964Yg008<4@07BWLH4bdEIa`L53PF>1D00S@E00Dh5S@E>1Dh5SPE008d
5@05>1Hd5CPE=1Dh5@02=1D2>1D01cPF>1DlMd2GDEXYBa2400@8a@0f48@8a@S52<D1YRSXE:`e9a3Z
DC9ilBfh<STFW@IoIBMmc5g>NBQeCgB8E0E80AcW:<<XQcQS;DLm83R734PhHacW4>Xm84P1?008i`EZ
7>LD22Q33B@DY@SW0P@M23P_0Nh29QU[7BTU:B480RDY00LQ22DY9BTPjB4X9BTQ20029BT01B3Y9BTU
:BDY8@P00bDY00TQ22DY7BTQ22DY8BPU:B3Y8BP00RDY00HQ22DY8@PU:E[FOol2BU82Ool>8@P00e[F
Oomg_@088@P00acW8@PQ20027>L012487>LQ21d80QcW00<Q21cW8@P00acW00AcO7ooOolU:@PLi`04
<Haoogoo8@P67>L02AS67>LHaQcW6<HLiaS67>LHi`036<H017NmOomcO2U;0c6<00D]JcF]Oomoobe[
00PHaP8DY@04=Jeoogoo7>L2Ool00dic5:DDY@0:5:D011S6OomoocF]1QBU00<@Q1BU5:D00aBU00@@
Q1BU48@DY@8@Q0075:D@Q12448AF]GooMkd02A2400=F]GooLg`02Q2400<<Ha2448@02Q2400001248
9BTQ22480RDY00<Q224X9BT00R4800LU:B489BTQ22DY8@PU:@038@P29BT012489BTU:B480bDY00<Q
22DY9BT00RDY00<Q22DY9BT012DY00D`=4THGY`m5fLL009cGP0:MkeooaPC=1Dh5C@E>1Hh5C@E>1D3
=1D01CPF=1Dh5C@E>1H00S@E00Th5S@E>1Hd5CPF?7LlUe5J:D/00PS500<@Q0S52<D010S50308iBU;
98eU9bR7CQUj]RgD<STFW@8L3OaP17`4OLaPZ604N6mD[1C5>6<LicdP:<<hHc538>T@jQSW8>TXj1QY
36<LhRQ330`1YP74:4=80@CZ48TX<@5^:<<IKP5g9BT28@P00bDY8@PU:@028@P29BT01B489BTQ2248
9BT00b480RDY0R480RDY00hQ22DY8@PQ22DY8@PU:B488BPU:B489BTQ25[F1Goo00=>LbU;8@P02b48
00iJeWooLg`Lib487>LQ:1cW8@PLib487>LQ21cW0R4800<Lib487>L00QcW00<Q21cW7>L00QcW00E6
<GooOomooekg00TLi`03<Haoogoo00<HaP037>LHaQS6008HaP057>LHaQcW6<HLi`066<H012e[Oomo
oaC511S600=BU7ooMkd00aS600HDYAS65<DDYAS65:D26<H00cF]Oomoo`03Ool00f<H>LhDY@0:5:D0
0bU;Oomoo`035:D00a245:DDY@035:D01a245:D@Q1245:D@Q1BU008@Q08DY@0648@DYA24F]Ioog=l
2A2400=:DWooLg`05a24000012DY8@PQ22DY0R4800HQ:23Y8@PQ22DY8BP28@P01bDY8BPQ22489BTQ
21dY008Q20089BTQ22488@PU:B489BTQ208U:@0;8@PU:BDY8@PU:B489BTQ21dY:34d]P03Ool026mK
Iaa5fEjL=1Dh5CPF>1D2=1D013PF=1Dd5CPF0SPE010d5CPF>1Dd5CPF>1Dd5CPE=1Dh5SQe?7M0Ue5J
:D/@Q088a@0348@8a@S500<8a@0C2@LXj2C;7C9A<WZfMU@]^4Gc3O`6O`LO3SM1;EE<E0E<QS6<?>`0
0RSX01dX@bS3<H`l03QS7BTXQ`U:66T]AcUAAO<lk4W>>KHiDDhBDSA5lcg_CQT@jP7498dX<CPC9BTQ
22DY00<Q20059BTQ22488@PM:@028@P01BDY8@PQ22DY8BP00R4800DU:B488@PQ22DY008Q20059BTQ
:2488@PU:@028@P012DY8@PQ25[F1goo00=JeR488@P02B4800]JeWooOom[FVmKLga_Fg=lKe]oocF]
008Q20/Li`03DYAoogoo009oo`03E[DLiacW00HLi`036<HLic6<009oo`I_F`04MkeNmaS66>L:6<H2
Ool01Ekg6<HHaQS65<D00Woo00I>LaBU6<HDYAS65:D26<H01ABU6<HDYABU=Jd027oo2QBU00<]Jgoo
Ool01ABU00<@Q1BU48@00QBU00H@Q1BU5:D@Q1BU48@25:D548@00eJeOomoo`0;Ool00g=l48@@Q006
48@00`aS48@<H`0<48@001`Q200L9BTQ22DY8BPQ22DY8BPQ22DY8@PU:B489BTQ22Pa@AMcO3Bf71@`
=1`D<3@m5a@F=1Dh5C@E>1H2=1D01CPF>1Dd5C@E>1H00c@E00Hh5SPE=1Dh5S@E>1H2>1D02Sag@9MA
FRU;2<D@Q0S536<8aA240PS500X8i@dT>8LhHdb2DNdk?UjL;KPb>@86O`0F3SL5mPIo3SL14@8L7Pll
k2C;4>XN3ekgCW8X`cQS:8M41aU[3B@X`cc/<Hd2>E403Adb=JliDAU[:D/iDC6<:<<PR`C;>1<h5R3Y
02@Q2007E[Eoof<H;F/icUJeMkd00Woo00=6<B488@P0124800DLib488@PQ25[F00Uoo`04BS4LiacW
8@P87>L00d8@Oomoo`02Ool00g=l9BTLi`097>L00aS6<Haoo`09Ool<6<H00d8@Oomoo`026<H011BU
CW=oogoo11S600@DYAS65:DHaP8DY@036<HDYCF]009oo`04<H`U:Cg_HaP3Ool95:D00acWOomoo`06
5:D02A245:D@Q1245:D@Q1BU48@DY@0248@00aBU48@DY@0348@00eJeOomoo`0;Ool00g=l48@@Q00E
48@002XQ200:<3@lMcBf<3@d5CPF=1DH4eGj>1H3=1D02cPE>1Hd5CPE=1Dh5SPE=1Dh5CPF>1D00S@E
00Hh5S@E>1Dd5CPE>1H2@9L01E5J:D/@Q0S548@01@S50108iASWB0]D[7ZfMUAB=5hDAMTb>@8L1KXV
mPhg0Q`5mP85^P8VA`0>;Ti6Dc/nLga5:3dP<D==@35366ThQa74?DeB=09MlP0=?>aB=3UA6O=5le8d
:D/TSCR7:8LL53PF9BT0924800=JeWooE[D0124800=[FWooOol01B4800HLib488@PQ21cWF]H2Ool0
2D8@BU9:DTYBCW=:DU:D:D/Q20097>L01U:DOomoogooE[DU:@8Li`0<6<HLiacW7>LHaQcW6<HLiaS6
7>LHaS6<0Woo00=>LdHaBU800dYB00=>Lcg_6<H031S60Woo00=6<AS65<D00Woo00IS61S65:DHaQBU
6<H25:D00aS65:DHaP025:D00c6<Oomoo`045:D0136<OomoocF]1aBU00D@Q1S6OomoocF]008DY@05
48@DYA245:D@Q0025:D01Q245:D@Q1BU48@DY@L@Q005E[EoogNm9BTYB`06;F/011cWHaQoog=l1a24
00<<Ha2436<03A2400028@P00acW8@PQ200<8@P00acW8@PQ20028@P00acW8@PQ200A8@P02S0dA=Pi
]QPC<3@h5SBfGYag_A`D0SPE00<h5S@E>1D00S@E00Dh5S@E=1Dd5CPF00<d5@07>1Hd5CPE=1Dh5SPE
>1H00Sag00AAFRU;2<D@Q0D8a@0>48@91a24AFmj]W/IMUAj4gT?NaUN508L6OHVmP85mP0G1KX5mP4A
FV8g47NmNa=Nn4KH:<<HJCQSAL5>8CdP88/X`d8@;H/lk3e=>6=5:002;DL02bSX6F/1KPC;0L@HaQdY
2M<Xj1d87>L01B4800DLib488@PQ21cW00<Q20047>LQ22487>L28@P00acW8@PQ20058@P00acW8@PQ
20038@P01AcWE[Eooekg7>L00b4800LLigooOolQ21cW8@PLi`028@P02ad87>LQ21cWG_MoofmK7>LQ
21cW8@P03AcW00D]JgooOomooaS600<Li`046<HLiacW6<H47>L01AS67>LLiaS6<H`00Woo5AS600E>
LgooOolDYC6<009oo`046<HDaAS65:D26<H011BU6<HDYAS60aBU00<e[GooOol01ABU00AS67ooKe/@
Q0PDY@0;JeYoogoo48@DYA245:D@Q1BU48@DY@0>48@015JeOomcO0aS212400A>LgooLg`<H`8@Q004
36<@Q12436<348@00`aS48@@Q00348@00`aS48@<H`0448@000048@PM22487>L58@P01AcW8@PQ2248
7>L0724800DX<CdGMkeNW7oo009g_@06Oomg_APC>1Hd5CPE0S@E00Hh5SPE=1Dd5CPF>1D2=1D03CPF
>1Dh5C@E>1Hh5C@E>1HhMCag@9MAFRU;00@8a@0?36<8a@SU4FQMcWID>E5N57/IG]4fEGE?GYa5f@8L
008>=`0>0Q`9daWc51H1kVJRAeaS65[gNaThQbS3:8LhH`95`@0DCR4HaSQS:8LLiaS61>XHJ@T73BPD
23P<2DY<PRR71FXTSDb28BPM20DQ20037@PQ2248018Q20037>LQ224800<Q20077>LQ22488@QJeWoo
F]H01B480Woo00A6<B487>LQ208Li`078@PLib487>MJeWooMkd041cW00LHaU[FOomooaS67>LHaP03
7>L00aS67>LLi`046<H01AcW6<HHaQS6<H`00Woo00<Q21S66<H03aS600@DYAS65:DLi`9oo`08;F]F
]GooOolDYAS65:DHaPTDY@03<Haoogoo00DDY@03@Q1oof]J00@DY@0648@DYA245:D@Q48@0Woo00@]
JaBU48@DY@8@Q0045:D@Q1245:D<48@00eJeOomg_@0948@00eJeOomcO00448@020aS48@@Q0aS48@<
Ha2436<;48@000037>LQ2248008Q20077>LQ21cW7@PLib487>L00b4800HLib488@PLib487>L28@P0
1QcW8@PQ21cW8@PLi`dQ200?:34m5gooGYaFUejL=;HL55jL51Hd5CPF=1Dh5SPE008d5@06>1Hh5C@E
=1Dh5SPE0S@E00Dh5S@E=1Dd5CPF008h5@90U`0UDEXYBa242<D@Q0S548@DaCDWGLijEV<HNQ=McTYg
NO5jETE_>KHb>AWf>Lh1M`Fj7C85^QUg9TMVc4KHAU=JeUhDABP]AcdP>6<00dG100=>04b288/00cR7
0Sc/02@IKSUA=BLX@db234Q<QQU[A0M`HbSX7>LQ21cW8@PLib487>LQ21cW8@PLib487>LQ21cW8@PL
ib487>LQ21cW8@PLib487>L28@P011cW8@PQ21cW0R4800/Lib487>MF]GooG_LLib487>LQ21cW009o
o`03=JdQ21cW008Q208Li`068@PLiacWF]IoogNm3QcW00HHaQcW7>MNmgooKe/37>L01AS67>LHaQcW
6<H011cW00<HaQcW6<H00QS600@]JgooOolLi`hHaP035:DHaQS600<HaP0<5:E_FgooOomcO7oo:D/H
aQBU6<HDYAS621BU00<aS7ooOol01ABU00=F]GooLg`01aBU00<@Q1BU48@00goo00<@Q1BU48@00QBU
00<@Q1BU48@00a2400<Lia2448@01a2400=F]GooMkd02A2400EF]GooLg`@Q0aS00@@Q00336<@Q0aS
00@@Q00436<@Q12448@236<348@136<000038@PLib48008Li`058@PLib488@PLi`028@P02AcW8@PL
iacW8@PLib487>LQ20027>L01B487>LLib487>L0124800DM21cW8@PQ21cW00<Q200;7>LQ22PaB?U6
f0`A61=>6APC71@XU002>1H2=1D04CPE=1Dh5S@E>1Dd5CPF=1Dh5C@E>1Hh5C@E>1Dh5SPE=1D00SPE
02DlMcbGDEXYBa242<D<Hah?;M@M<SQSEDafE5gbNO5McWE?NQ=k6G:^H:Qh[2B=DC81MaWc7C8iDBR7
FV9Vc7[@<SUj]W/ICD0e9`02:<<023dPAL55`DhQ<H=5Ke:D=Jl3CQ803TE_AU<IJ``73B@]Y696H/DR
0C637>LQ21d87>L28@P011cW8@PQ21cW0R4800DLib487>LQ21cW008Q20057>LQ22487@PLi`028@P0
0acW8@PQ20027>L02R487>LQ22487>LQ25JeOomF]B480acW00IBU7ooOolQ21cW8@P27>L00b487>LL
i`027>L00e[FOomcO00:7>L021S67>LHaQcW6>LLiaS6E[D2Ool01aS67>LHaQcW6<HYBg=l00XHaP03
<Haoogoo00/HaP045:DHaQBU5:D26<H00aBU6<HDY@026<H00b4XOomoo`02Ool>5:D00c6<Oomoo`05
5:D2Ool02Ukg48@DYA245:D@Q1BU48@DYA240QBU0goo2A2400=JeWNm48@0212400=F]GooMkd01a24
00H<Ha24E[Eoog=l36<248@010aS48@<H`aS0Q240`aS0a240PaS11240@aS0A2400047>L00b487>LL
i`087>L00b487>LM20037>L01Qd87>LM21cW8@PLi`8Q208Li`038@PLib48008Li`0<8@PLiacW8@PL
ib48<3@d5BRD>1HXU5jL0Q`D00Pm5c0d>1Hh5C@E>1Hd5CPE0S@E00Dh5SPE>1Hd5CPF00<d5@04>1Hd
5C@E=1D2>1H013ag@9MAFRU;0`S500<=:1Ug5Yd00PFj01Amc7/CNQ=eBdE_G]5jEWg<?9Mh2D4]6GLm
C@`A7C8U:AQYEXe6f7:^0S/n00]N53`0=BLHaSQSCD1>8DG18P55`BR7008lk00>:D/lk4b6?>`1KQU^
>E56<Fk1H/EVa2U;0A4Q20dLi`038@PLiacW00dLi`037@PLiacW00@Li`03E[Eooe[F008Li`05:D][
FWooOom_F`0:7>L025[FOomcO1cW8@PLib487>L28@P57>L01QS67>LHaQcW6<H]J`9oo`05MkdHaQS6
6<HQ2003Ool96<H012e[Oomoob480QS600DLiaS67>LHaR48008HaP035:DHaQS600<HaP045:DHaQBU
6<H35:D3Ool00cg_5:DDY@0<5:D0136<OomooaS60QBU00i247ooOomooa245:D@Q1BU48@DYA245:D@
Q1BU0Q2400D]JgooOomooeJe00D@Q0059BUg_GooLg`<H`0848@015JeOomg_@aS212400=F]GooLg`0
0Q2400<<Ha2436<00a240PaS112400L<Ha2448@@Q0aS48@<H`0248@001dLi`8Q20037>LQ21cW008Q
200@7>LQ22487>LQ21cW<3A0N34f314L55Gj314XU6LL71@2=1D01SPF=1Dh5S@E>1Hh5@<d5@05>1Dd
5C@E>1Hh5@02=1D03CPF>1Dh5CQe?7M0Ue5J:D/8aA242<D<H`T70086O`0J;KP=o3IE9_INdGIDOLai
:4gV;AEA<U7]<He82`4A98d14Be[Ob0g46LLNaU:McF]:8LiZ08hH`06?B1>8DG1AL5>04E_0TGc00IB
=4E_AFmFSE8;FVD2EXd01UYRH/EVa3P_51HQ22@Li`03F]Ioogoo00Ioo`/Li`03G_Moogoo00Moo`0<
HaPHaQS67>LHaQcW6<HLiaS67>LHaV<H0goo00=_FgooOol00Woo00<YBaS66<H01aS600<aS7ooOol0
27oo00@DYAS66<HHaP@DY@046<HDYABU6<H35:D00c6<Oomoo`0?5:D00cF]Oomoo`06Ool03Be[5:D@
Q1BU48@DYA245:D@Q1BU48@DYA24008DY@Eoo`03JeY_Fgoo00=oo`03G_L@Q12400L@Q004F]Ioogoo
36<548@01PaS48@<He[FOomg_@8<H`0348@<Ha2400<<H`0<48@<Ha2436<@Q0aS48@<Ha2436<@Q0aS
0Q240@aS000Y7>L01Qd8:3515fLL?AMEnPAoo`0461<h5SPE>1D2=1D02CPF=1Dd5CPF>1Dh5S@E>1Hh
5@02=1D02cPF>1Dd5C@E>1Hh5Cag@9MAFRU;48@00`S500P48A5X3O`]^0Fj>KIi:6ea0Wg<01]ilGB8
N0UEC1h??;Dh;cF_ABPPRd75N]1NdAJMEDaj4gR/C88e9cdP>8Lm84h0CR4R0Dh0=BL00RQ300Ha@cQS
>6<X@dh0FV82CP001UYRH/EVXRB=51HM22@Li`03F]Ioogoo00=oo`03Mke:DQcW00/Li`03F]Ioogoo
00Moo`04F]HLiaS67>L26<H00aSW6<HHaP036<H00dicOomoo`04Ool00acW6<HHaP086<H00c6<Oomo
o`08Ool00aS65:DDY@056<H011BU6<HDYAC511BU00=oof<H5:D03ABU00<@Q3F]Ool017oo00=g_F]J
5:D00QBU00H@Q1BU48@DYA245:D848@00e:DOomoo`05Ool00gNm<H`@Q00848@010aSE[EoogNm0a24
00<<Ha2448@00a2400MF]GooMkd@Q0aS48@<H`0448@03@aS48@<Ha2436<@Q0aS48@<Ha2436<@Q0aS
008@Q0002AcW00<HaQcW7>L07QcW00DX<CBfOomoog=N009NW00<>KIW71`D=1Dh5S@E>1Hh5C@E>1Dh
5SPE0S@E01Th5C@E=1Dh5S@E>1Dd5CPF>1Dd5CPE?7M0Ue5J:D/DaABU2<D<H`S57>8IKRfh>E4IM`03
OL`047WaOLaeBgR/MJM41`5g:9Ai:2C;6FiQXfK<LZh]e38i0WYF00IU9cdP>6<X@db2CP02AL402DhQ
:4<LhRQ3:<<X@b3Y:4==@002CP001ThQFV9RaEYU98dD5RHLi`049BTQ22488@P@7>L01bDY7>LLib48
7>LQ21cW008Q20047>LHaQcW6>L:6<H013g_AS56<Be[2QS600<DYAS65<D00QcW00DHaQcW6<HLiaS6
008Li`078@PDYAS66<HDaABU5<D02QBU00=243g_5:D02aBU00@@Q1BU5:DDY@<HaP045<DLia245:D3
48@01ABU48@DYA245:D00Q2400<DYA2448@01Q2400HQ23F]@Q0mkcW>7>L648@010aS48@@Q0aS0Q24
00HDYAS65:D<Ha2436<248@236<02A2436<DYAS65:D<Ha2436<@Q00836<02A2436<@Q0aS48@<Ha24
36<@Q00236<000036<HLiacW00@Li`036<HLiacW010Li`036<HLiacW00dLi`03:35966LL008XU005
=1DL544GEOXh5P03=1D013PE=1Dd5CPF0c@E00Ph5S@E=1Dh5S@E>1Hd5CPF0S@E0SPF00@lMd2GDEXY
B`88a@0948@8aA241241SPIo<CH=o5B/009mc09McP0FIBMi3fDWN0T`=3R766U5:1dYBLiU9e[gMUAj
EWXCNUI]LCDW>6=80CdPCR42AL401Dh09BTlk3DW@Bd00Se=00Q1;E7]BS5:<DGcHXIVa6;50UYU00<H
iacW6<H09AcW00<HaQcW7>L02QcW00@HaQcW7>LHaPDLi`036>LHaQcW008HaP037>LHaQS601PHaP03
5<DHaQS600@HaP065:DHaQBU6<HDYAC57QBU00`@Q1BU5:D@Q1BU48@DYA245:D@Q1BU48@25:D00a24
5:D@Q00P48@00`aS48@@Q00348@00`aS48@@Q00348@020aS48@<Ha2436<@Q0aS48@236<0312436<@
Q0aS48@<Ha2436<@Q0aS48@<H`8@Q04<H`4@Q00000HLiaS67>LHaQSW6<H27>L26<H01AcW6<HHiaS6
7>L00QS600HHiaS66<HLiaS67>L26<H27>L00aS67>LLi`0<7>L00bPa?9Lm5`03=1D01S0dEOYg_BRD
=1Dh5P8d5@0=>1Hh5C@E=1Dh5SPE=1Dh5SPE=1Dh5C@E>1D00S@E00Ph5SPE>7DlMd2GDEXYBa240PS5
03<@Q0S536<DY@Gf5]h=o0IoDNei:7E;N]1PZ5E<D4ah2GT?6F/PjBSX48URQV96CQ9]LGYFN@mMlVea
C891aC`0:4=>8Dh0CR55`DE_DS@e[eE<DNe5:4hBHTIJHV:6FVEJHV;5HXH00VK40acW00THaQSW6<HH
aQcW6<HHiaS67>L00aS600PLiaS66<HLiaS67>LHaQcW0aS600DLiaS66<HHaQcW008HaP0E7>LHaQcW
6<HLiaS67>LHiacW6<HLiaS67>LHaQcW6<HLiaS67>LHaQcW008HaP037>LHaQS6014HaP0;5:DHaQS6
5:DHaQBU6<HDYAS65:DDa@035:D01AS65:DDYABU6<H08ABU00H@Q1BU48@DYA245:D248@02ABU48@D
YA245:D@Q1BU48@DY@0248@00aBU48@@Q00I48@020aS48@<Ha2436<@Q0aS48@336<00a2436<<H`03
36<00a2436<<H`0;36<00a2436<<H`0436<00a2436<@Q00636<148@136<000036<HLiacW00<Li`04
6<HLiacW6<H;7>L01aS67>LLiacW6<HLiaS600<Li`036<HLiacW00LLi`066<H`=30d=1E053PE0SPF
00HX<EjL71@h5SPE>1H3=1D03SPF>1Dd5C@E>1Hh5C@E>1Hd5CPF=1Dh5SPE=1D2>1D01cag@9MAFRU;
2<D@Q0S5008@Q088a@0R4FP6Oc4f<STIKW1SGLieBgg<IBM8C5B/:8MEC2DY;F/@RDe0MBAeYdhB@?E]
LGE?NO5h[3DW>6<X@de0I/AVXUd19</2?>`02DgVAFmA<Tb2HT=JHVJRCP1JHP03H/D00fK47>LHaP0@
7>L00aS67>LHi`0<7>L00e:DBU9:DP0jBU800dHaBU9:<@0=BU800dHaBU9:DP02BU800dXaBU9:DP02
BU8024HaBU9:DTHaBU96<DYBAS42BU8014HaBU9:DTHa0TYB0dHa00=:<DHaAS401DHa00=:<DHaAS40
=THa00A>Lb4836<@Q08<H`0448@<H`aS48@236<0112436<@Q0aS0Q240PaS00066<H00aSW6<HHaP0<
6<H00aSW6<HHaP026<H00acW6<HLi`026<H01QcW6>LHaQcW6<HHi`<HaP087>LHic0d@7Pa=QPC71@`
=08L5008GY`d5C@E>1Dd5CPE>1Hh5@8d5@09>1Hh5C@E=1Dh5S@E>1Dd5CPE008d5@0h>1Hh5CPF?9M0
Ue5J:D/@Q0S548@8aA242<D<Had8?9L6OaWfH:QdR6DWNBQeYg`4H0@]e1S6C8ID[3DW:D]e97:^GLim
c6eaDSAilE4bNUIEC353?00hQde0ABQ80E8d@Q1EC3e=@BeRAT@7CNIRa@9RQP06FV9JIF;5CNI5KacW
4AS600<LiaS66<H02aS600<LifmKHaP07F<H00=Nmf<HHaP05F<H00ANmf<HHaQNm`MS6008G_MS65kg
HaQNmf<HG_MS60=Nm`06HaQNmekgG_MNn6<H15kg00AS65kgG_MS609Nm`03HaQNmekg00QNm`0;HaQN
mf<HG_MS65kgHaQNmf<HG_MNn00hG_L00f<H;F/<H`0736<00a2436<<H`0536<148@136<001`HaP07
7>LHaQcW7>LHaQcW6<H00QcW00THaQcW6>LLiaS6:3515gNmAMT00VLL0VmK00Ig_APC>1Hd5CPE>1H3
=1D02CPF>1Dd5C@E>1Hd5CPE=1Dh5P02=1D09SPF>1Dh5SPF?9M0Ue5J;F/DY@S548@8aA242<D<H`7^
;KPl]@IoE:aeBgg<MB@lk601H:PXj3R74>XhQbC;6F]h0GFW@Q1U9gg<MD/2KG401GWaMD]EC3dPA0L0
0TP100YM0BQ3:4<U:BR7@LE<QT@7CD1Ra@=RQP05H/EVXSP_51HHJ@126<H00aBU6<HDa@026<H03QBU
6<HDYAS65:DHaQBU6<HDYAS65<DHaQBU6<H25:D26<H011BU6<HDYAC55ABU00<@Q1BU5:D00QBU00@@
Q1BU5:D@Q08DY@8@Q0@DY@0548@DYABU48@DY@0J48@00`aS48@@Q00448@01PaS48@@Q0aS48@<H`8@
Q00736<@Q0aS36<@Q0aS48@00PaS00@@Q0aS36<@Q08<H`0348@<Ha24008<H`0448@<H`aS48@?36<0
112436<<Ha240`aS000Z6<H032Pa=;IoogNmLeig_FLLAMUW71`D=1Dh5P<d5@05>1Hh5C@E=1Dh5P02
>1D01S@E>1Hh5C@E>1Hh5@8d5@8h5@08?7M0Ue5J;F/8aA242<D@Q088a@0N1245TPIo<ST=o3UAMJMe
BgDTNBQEC3P<C8HaS1U^:D/e9acW>8MHHVDWAFmhKgE;AFm@C7DTABPPRdDX0SQS00XhQc53C89<PRR7
:<=<QTDXCNIQX`IRQP0398dD5QSW04DHaP065:DHaQS65:DHaQC50QBU00<HaQC55:D00aBU00<HaQBU
6<H07ABU00<@Q1BU48@00QBU00D@Q1BU48@DYA24008DYBD@Q00536<@Q0aS48@<H`0248@010aS48@<
Ha240PaS00@@Q0aS48@<H`8@Q0D<H`0448@<H`aS48@D36<00a2436<<H`0836<000THaP035:DHaQS6
01hHaP0;:35966LL61<d5BPa71@H4dhI>1Hd5@02>1D01CPF>1Dd5CPE>1H00c@E00Dh5S@E=1Dd5CPF
008d5@0T>1Hh5CPF>1DlMd2GDEXYBa242<D<H`S548@8aAcR1I8=o05g;KPed7DTNBQeYgP9>8M<PTDX
>6<hQcDW?>`YBd@7MBAi:6ea0WT?019mc475CD0m83DWABQ1aEd1CD1M0Db6HT<hHcR7?>aQXe8;HTH4
HXH01F;5I/@h;a@F6>L0:1S61c6<00<e[AcW6<H011S600T]Jc6<<H`aS2e[<H`]RcF]9BT00aS600HD
YAS66<HHaQBU5<D35:D00bDY;F]6<@02CW<00cF]:D/DY@095:D28@P;7>L01B487>LDYABU8@P01AcW
00`Q21cW5:D@Q1BU48@DYA245:D@Q1S68@P47>L00aS69BT@Q00348@01R486>LHaQcW6<HLi`8HaP8L
i`DHaP057>LDYA2448@<H`0248@010aS48@HaQcW1AS600<Q21248@P01aS600<@Q0aS48@00PaS00@L
iaS66<HLi`8<H`0648@<H`aS7>LHaQBU0QS600<DYAcW6<H05`aS000Z6<H0130d?9La=S0d0SPF00Hd
5CQeOolXU3@E>1H3=1D02SPF=1Dd5CPE>1Hh5C@E>1Dh5SPE0S@E00<h5SPE=1D00SPE00PlMd2GDEX]
J`S548@8aA240PS501D@Q1h?0A4Ilc4f98eU9gTXO0A5:5QRE0DX`bC;C88TbbR7:>Q<QV2XIBL00WE;
01=h[475;H/e9ed1C89<QRDYG@5HHSe=ABQD1BS3>JQ<QTgVEDaRAP06HXH00dgVBLhDa@0X6<H8Ool0
1V<H6<HHaQS65:DDa@Uoo`036<HDYAS6008HaP8DY@046<HDYBU;G_L9Ool00f]J?NlDY@065:D>Ool0
0gNm5:DaS008Ool02A245:D@Q1245:D@Q1BU48Ag_@07Ool012DY48@@Q5Je4Goo1Q2400<U:GooOol0
1Woo00<DYGooOol01Woo10aS1Goo00EBU0aS36<<HacW00Moo`03Mkd<H`aS01D<H`0000DHaQBU5:DD
YAS6008DY@045<DDYABU6<H55:D01AS65:DDYABU5<D00QBU00DHaQBU6<HDaABU00hHaP0;:354f4hI
61<d5CPE<3ANW4GI71@h5P02=1D01SPE>1Hd5C@E>1Dh5P<d5@06>1Hd5C@E=1Dh5SPE0S@E0SPF00@l
Ud2GDEX]J`8DY@8@Q00G36<LhRfT51H>=bfh0A4lk7TXL6=l14b29BT1kS8i1al>=bfh=BL1STb2L6=E
C002M8P04fW0G@4PRaU[>6=41de0C8I<PTDXC8IM0CR7>JPlk6DWABQ41f96009RQP04EXeRQV:6HXH2
H/D011S65:DDYAS61aBU00DHaQBU5:DDYAS600TDY@056<HDYABU5:DHaP035:D00aC55:DDY@035:D0
0aS68@Qoo`07Ool01WNm5:DHaQBU6<HYB`Uoo`095:DDaAS65:DDaABU6<HDYF<H00ioo`HDY@ioo`03
Lg`@Q36<00Qoo`0448@DYA245:D448@00fmKOomoo`05Ool00bDY48@@Q009Ool00be[Oomoo`06Ool3
36<0112436<<Hdic27oo00<<Hf<HOol01Woo0PaS00<@Q0aSOol017oo00EcO0aS36<<HaBU00Moo`03
E[D<H`aS01D<H`0000<DYAS66<H01QS600<DYAS66<H02aS600<DYAS65:D00QS600<DYAS65:D02AS6
00TDYAS6:34d]WooGY`d]Q`D<3@00c@E00Lh5S@E>1Hd5CPE=1Dh5P02=1D01cPE>1Hh5C@E>1Dh5SPE
008d5@08>1Hh5C@E>1DlMd2GDEX]J`DLhP0N?B0IKPgl51H9dbB=M8Qi:7`4ABQRaBKf>chFgQdb6OHF
gQUg0GL5TUQRIBMPZ7g<HT<XQbC;:D/aSCdP0Tb200`lk3G@B05<PSg_F68hQe8;CNHD258;H/D2HXH0
1UJ=HXIRQV;5HXHDaBHHaP035<DicWoo00Qoo`057>LDYAS65:E>L`09Ool75:DAOol00bU;5:DDY@02
5:D>Ool00fmK48@]J`07Ool00gNm48@@Q00648@00f]JOomoo`05Ool00b4848AJeP08Ool00bU;48Ao
o`07Ool00f<HBU9>L`02CW<00dHaMkeoo`06Ool00e:D36=:DP07Ool011BU36<<Hcg_1Woo00@DY@aS
36<YB`Moo`03@Q0<H`aS01D<H`0000DDaABU5:DDYAC500LDY@035<DDYABU00TDY@046<HDYABU5:D3
6<H25:D01QS65:DHaQBU6<HDY@8HaP0:5:DX<CdGMkecGWooL]e5fD2G<3@2>1H00cPE=1Dh5P02=1D0
0cPE>1Hd5@02=1D01SPF=1Dd5C@E>1Hh5@8d5@09>1Hh5CPE?7M0Ue5J:D/Da@S500<@Q00R4>X1M`4A
;AD9BRPaIBMdR4759TLJMFDWAMTb<4DX>KHFgRfh0Q`M<SG@N05EC7E;C88TbbU;>8LTbaU^<Hde9cdP
>6<2>JP01dE_CNIHHS6<BLi80F6S00ERQP04I/AJIE8;6<H;5:D00aC55:DDY@0:5:D00aC55:DDY@0<
5:D00ekgOomoo`07Ool01CW>5:DDYABUJeX02Goo00<YBaBU5:D00aBU4goo00@U:ABU5:D@Q0ioo`03
Ke/@Q2e[00Moo`03Mkd@Q12400H@Q003JeYoogoo00Eoo`037>L@Q7oo00Moo`04Ke/@Q0aSF]HEOol0
0c6<36<]J`07Ool011cW36<<Hg=l1Woo00@icPaS36<U:@Moo`037>L<H`aS01D<H`007ABU01HDaABU
6<HHaQBU6<HDYAS65<DHaQBU6<HDYBPaA=Q5f@`AG_QNW7ooMkeNW0<d5@04>1Dd5CPE>1H2=1D01SPE
>1Hd5C@E>1Dh5P<d5@05>1Hd5C@E=1DhM@02@9L0555J;F/@Q12436<8aA242@L4b`CZ6F/4bcP_=BL]
Y0>5=a1j]W[@<S021al041KN=M05^SUA7C8=o71SNBQPZ3QS6F/Xj4b29BTe[cDW0S6=00`mCCg_ABPl
k4DXC8I9cTibG@5JIF96G/d2HXH015k=G]4X<A@F:1BU00=_FgooOol01goo00ANmaBU5:DDY@Yoo`03
CW<DYABU008DY@03Lgaoogoo019oo`0348@DYABU00ioo`03Ke/@Q2e[00Moo`03Mkd@Q12400H@Q003
JeYoogoo00Eoo`0336=JeWoo00Moo`0448@<Ha2436<EOol336<7Ool00cF]36<<H`07Ool016<H36<<
Hd8@1goo2PaS00<48@aS36<02`aS000Z5:D02c0d=1DL51`D@AL<4DYgOoli]S@E>1H00S@E010h5S@E
>1Dd5CPF>1Dd5CPE>1Hh5C@E>1Dh5SPE=1Dh5@<h5P04?9LlMe5J;F/248@010S536<8aA240PS50208
aPEZ6Fhlk475EXe7G59cIaak4bgDDC8i]SUA;M@2754b1KXiDG1SM8PM:BC;C89=@2B==BMHHSc/=BM<
PTDX0RC;00I5:3g_HJ=5:58;HTH3HXH01EYUG/e>6C0d>1<0:1BU2goo0QBU00<YBgooOol027oo00EJ
eQ245:DDYBe[01Eoo`03CW<DYA2400ioo`03Lg`@Q2e[00Moo`03Mkd@Q12400H@Q003JeYoogoo00Eo
o`038@Qoogoo00Ioo`039BT<Ha24008@Q1Aoo`04F]H<H`aS36<7Ool00cg_36<e[@08Ool236<00dXa
Oomoo`05Ool836<00`@Q36<<H`0436<010@Q36<<H`@Q1@aS00095:D00a245:DDY@0N5:D02CPC@7PX
U0`AGYacO5Gj61<L5003>1H3=1D01CPF=1Dd5C@E>1H00c@E00Hh5S@E=1Dd5CPF=1D3>1D013ag@9MA
FRU;0Q2400@8aA242<D<H`<8a@0;2>L9BRC;ABQo^W[@MBAk6GWaN:aN50020Q`02Bfh;M@a=U4b3OaE
C7B86FhXQ`02C8800aU^9<]M0@02ABP02CR7>E5M0EQR>Li9cTb2?>a=iP02HTH01EYUFV9R@ek=BWL0
0RPa00<@Q1BU5:D09ABU2goo00<HaQBUAS402goo00@DYA245:EcO0Uoo`03Ke]Nmf<H00Yoo`8@Q0io
o`03Mkd@Q2e[00Moo`05Mkd@Q12448@<H`0448@00f]JOomoo`05Ool00gNmOomoo`05Ool016<H36<@
Q1240PaS00=6<GooOol04Goo00@Li`aS36<<H`Moo`03F]H<He[F00Qoo`03:D/<He[F00Ioo`04Lg`<
H`aS124936<00`@Q36<<H`0936<002XDY@07:358nEkh>KINW3Bf61<00SPF01D`=3@E>1Dh5SPE=1Dh
5CPF>1Dd5CPE>1Hh5C@E>1Dh5SPE=1Dh5CPF=1D00SPE00XlMd2GDEX]Ja242<D<Ha242<D@Q088a@0G
2<H8ia3Z6>MVc6mKNO5b[VmKAFmj4gE?@Bd272fh6OH6OcVf0GLImWTX6F/IKP02>8L03S6=:>Q<PTDX
@BdTbc6=ERA5:2Kf=O0X@dE_AL42HTH01f:6G/eRQUk=BWLmCBdE00LDY@0348@DYA2401@DY@0348@D
YABU00HDY@039BUoogoo00Uoo`03CW<DYF<H00]oo`8DY@0348Aoogoo00Moo`037>LDYABU008@Q003
Mkeoogoo00Ioo`03;F/@Q7oo00Moo`038@P@Q12400D@Q003;F]oogoo00Ioo`96<@9:DP05CW<mka24
36=[FP0>Ool01W=l36<@Q0aS48@<H`8@Q0Qoo`03Ke]cO7=l00Qoo`@<H`03F]Ioogoo00Aoo`03G_L4
8Goo00Qoo`03JeX<Hf<H00Ioo`03E[D<H`aS008<H`07124<H`@Q36<48@aS12402@aS00<48@aS36<0
0@@Q000248@25:D00a245:D@Q0025:D011245:D@Q1BU0Q2400HDYA245:D@Q1BU48@25:D01A245:D@
Q1BU48@02QBU00P@Q1BU5:DDYBPa?AMcGSVf0S@E0SPF00L`=55J?;Dd5CPE=1Dh5P03=1D01CPF=1Dd
5C@E>1H00c@E010h5S@E=1Dh5CPF>7DlMd2GDEXYB`S548@8a@aS2<D@Q088a@0;48@8a@dX:>Qjd7Wa
F_MF]G[@NUIeC`02DC802AUgA=Q5K`Fj0GM5:08LDC8hQ`021I803Re[9BThQe@5;F/TbdP1C8Hb<2gD
ABPfECc/C883HTH3HXH015k=AU=F]BU;0QBU11241ABU00<@Q1BU48@00aBU0Q2400<DYA245:D00Q24
0QBU00<@Q1BU48@00aBU00<@Q1BU48@00Q2400<DYA24BU8037oo00<@Q7ooOol02Woo00<HaQBU>Lh0
27oo00DHaQ2448@@Q1BU008@Q0Qoo`03E[D@Q7oo00Moo`035:D@Q12400D@Q003:D]oogoo00aoo`03
36<@Q6]J00ioo`03AS4<H`aS008<H`0448@<H`aSLg`6Ool017Nm36<<HbDY1goo00=240aS36<00PaS
00=>LgooOol017oo00=_F`aSOol02Goo00<48FmKOol01Goo00<]J`aS12402PaS00L48@aS124<H`@Q
36<48@0536<0000:48@DYABU48@DYA245:D@Q1BU48@35:D03Q245:DDYA245:D@Q1BU48@DYA245:D@
Q1BU48@25:D011245:DDYA242ABU00HX<DSiBWL<4C@E71@261<01P`<Iaa4f1PC>1Hh5@8d5@06>1Hh
5C@E=1Dh5SPE0S@E00`h5SPE=1Dh5CPF=1Dh5CPF?9M0Ue5J;F/248@01@aS2<D8a@S548@00`S500T4
jQcWN]1k4dYgNaUk4feaN@l00TGc00`ImP8L?>`X@`C;C895:0Fj:>Q80A3Z1I82<Hd02bU;<H`iZ3G@
6WDfEDb6B04fEEd1HJ<00UHT00QRAUYUFVEJHUJ=BWM>LRf;0Q241ABU0Q2400HDYA245:DDYA245:D2
48@45:D02a245:DDYABU48@DYA245:D@Q1BU48@00QBU00H@Q1BU5:DDYA24F]H<Ool00a24Oomoo`0:
Ool00be[5:E6<@08Ool748@00dYBOomoo`05Ool00f]J48Aoo`07Ool00b4848@@Q00348@00`aS48@]
J`0=Ool016]J36<@Q6]J47oo00<YB`aS36<00`aS00=247ooOol01Goo00<Q20aSDY@01goo1@aS00<U
:GooOol017oo00=g_AS6Ool02Goo00<Q27NmOol01Goo00DLi`aS36<<H`@Q008<H`06124<H`aS124<
H`@Q2@aS0@@Q0@aS0@@Q00001aBU48@@Q1245:D@Q1BU00H@Q0055:D@Q12448@DY@0248@011BU48@@
Q1BU0a2400@DYA245:D@Q08DY@P@Q0055:DH4d3eLeiAFP02EOX3Ia`01g=N>1Hd5CPE=1Dh5SPE008d
5@06>1Hh5C@E=1Dh5SPE0S@E00/h5S@E>1Dd5CPF>1DlMd2GDEX]Ja2400<8a@0336<8a@S500<8a@0H
34Q=iWnjLeiN57/IMJMi3gZfAFmA<SVf1KXHJDe0:8L4ba3Z2M=<PTe0B045TPWC0aWc00PJMC8`6O<I
lc`0C88fEDb20V6S0V960f:600EFSDYg@Q0mCABU00H@Q0035:D@Q1BU00<@Q0035:D@Q1BU00D@Q003
5:D@Q124008@Q0055:D@Q12448@DY@0348@00aBU48@@Q00248@6Ool00gNmJeYoo`04Ool00ekhOomo
o`02Ool00g=lMkeoo`05Ool00cg_48@mk`07Ool00fmK48@@Q00548@00cg_Oomoo`05Ool00f]J48Ao
o`07Ool00acW48@@Q00548@00bU;Oomoo`0;Ool016mK48@<Hf]J4Goo00<Q20aS36<00PaS00<DYGoo
Ool01Goo00<mk`aSOol01Woo00=_F`aS12400`aS00<HaWooOol01Goo00=F]GooOol00Woo00=g_Goo
Ool00goo00=S66]JOol01Goo00<48@aS12400PaS0P@Q00<<H`@Q36<00`aS00P48@aS36<48@aS124<
H`@Q10aS000L48@011BU48@DYA242ABU00@@Q2Pa<CIoo`9g_@03LeiW75jL009oo`8`=00B>1Hd5CPE
=1Dh5S@E>1Dd5CPF=1Dh5C@E>1Hd5CPE=1Dh5S@E0SPE00HlMd2GDEX]J`aS7>8236<0:@S536<8aA24
2<D8aPS5DP]o^UkACNI=@4G1HTIfE3VfCS@]^3F_:4<X`dG148T1KR2;F69<PRR72M=41cQS>8L>=cc/
H04lk2gD>6=5l`WCG@400f6S00UNcEJ=EXeFSE9cDY@X<APC5:D09Q241goo00=6<GooOol027oo00=B
U5JeOol01Goo00=Nma24@Q001goo00=g_A2448@01A2400<mkgooOol01Goo00=_Fa24Ool01goo00HL
i`aS48@<Ha2436<248@00bU;Oomoo`0;Ool016mK36<<Hf]J4Woo1@aS00=g_GooOol017oo00=F]@aS
Ool01Woo00<aS0aS36<010aS37oo00<mkfmKOol02goo0`aS00<48@aS36<00`aS00<48@aS12400PaS
00@48@aS36<48@<<H`03124<H`aS00448@00:Q2400XX<DSiKe/M<SBf314H4dGIIa`a=P8d5@8h5@06
>1Hd5CPE>1Dh5S@E0SPE00hh5S@E>1Dh5CPF=1Dh5C@E>1Hh5D2G?7MAFRe[0Q2400<<H`SU36<010S5
00D8aQdTNa=6f3dP00@LhP0O?B1A<U5J;KQ=@3dP66U<PQBU0A4IKRR7B04Pj@WCCD0hHcdP6OHe9bQ3
=BLfECG@6F/e9ed1HJ=JIF96A]P00dYg00A>Le9c:34`=2H@Q0036<Ioogoo00Eoo`0348Aoogoo00Qo
o`03=Je>Lgoo00Eoo`03HaP@Q3W>00Qoo`L@Q0Qoo`03G_L@Q7oo00Moo`097>L@Q0aS48@<Ha2436<@
Q2U;00ioo`8<H`03JeYoogoo00Eoo`03<H`DYDHa00Qoo`0348@<H`aS008<H`03CW9oogoo00Aoo`03
HaPYBgoo00Ioo`05124<H`aS36<48@0236<00g=lOomoo`09Ool00`aSE[Eoo`0:Ool00f<H36<48@02
36<01@@Q36<48@aS12400PaS00D48@aS124<H`@Q00<<H`05124<H`aS36<48@0136<002X@Q00=>1<l
UcVf71@<4C4fIaaEnQPC71@h5S@E>1H00c@E00Dh5S@E=1Dd5CPF00<d5@0<>1Hd5C@E=1Dh5S@E>1Hh
MCag?9MAFS6<0Q240`aS00X8a@aS2<D8aA24;DL]Ra24:<<a@`@m8007ABQ8nBfh>6==@36330L00`C;
0105TRSX6Fh5TTP1>6<hQaYe>6<l03e=6WE<QRR7C89M0@9QX`07FV9F]DicDYA>LTicDW<00QP@00<<
Ha2448@08a2400<aS7ooOol01Goo00<@Q5JeOol027oo00<@Q3F]Ool01Goo00=g_A2448@027oo00=g
_@aS48@00a2400=247ooOol01Woo00<icPaSOol01goo00HLi`aS48@@Q0aS48@236<00be[Oomoo`05
Ool00gNm36<@Q00248@01ABU48@<H`aSJeX01goo00@@Q0aS36=g_@Moo`036<H<H`aS00<<H`Ioo`03
MkeBU7oo00Eoo`04F]H<H`aS124336<00`@QJeYoo`0:Ool00`@Q=Jeoo`0:Ool01dYB124<H`aS124<
H`@Q008<H`05124<H`@Q36<48@0336<020@Q36<48@aS124<H`@Q36<1124000T@Q00336<@Q12401h@
Q009:34h5P`A61=>6FLL:9@H4c@E008h5P8d5@0K>1Dh5SPE=1Dh5CPF>1Dd5CPE>1Hh5C@E>1Dh5SPE
=1Dh5C@E>1HlMd2GDEXYBacR5:D@Q0aS0088a@0436<8a@S52<D22<H00acR?B0m8005?B007E5J6GLm
83dPCD0a@`4A>6=M0B480A45TQWc:>PhQbC;6O<aSBgD6WD9ddP19<]<PUd1ERARQV93BWL01Dic00E2
436=48@@Q0aS008@Q00436<@Q12436<648@00`aS48@@Q00@48@01@aS48@@Q124@Q001goo00<@Q1S6
Ool027oo00<<Hcg_Ool01Woo0Q242Woo00@e[A248BQcO0Uoo`0336<@Q7oo00Moo`097>L<Ha2436<@
Q0aS48@<HbU;00Moo`03Mkd<H`aS00H<H`03JeYoogoo00Eoo`<<H`03Mkeoogoo00Eoo`035:D<H`aS
00<<H`03Mkeoogoo00Aoo`03Mkeoogoo00Aoo`03<H`48@aS008<H`04124<H`aSDY@:Ool00gNm36<4
8@0;Ool01SF]124<H`@Q36<48@8<H`0?124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q008<H`44
8@0000<<Ha2448@00a2400<<Ha2448@00Q2400<<Ha2436<0112400@<Ha2448@<H`<@Q00336<@Q124
00h@Q005>1<XU4GIOomNW00231400c@E>1Hh5P02>1H3=1D01CPF=1Dd5C@E>1H00c@E00Dh5S@E=1Dd
5CPF008d5@08>1Hh5D2G@9MAFRC;5:DDa@@<H`082<D@Q0S52<D8aPS5?B0LhP<m808X``0<?B0e9adb
C88m84h0CD0]AaQY>6=HHRQ30PFB00lIKPWC2M<>=aU^>6<5TSW>:4<XQed1HJ=RAVJRFV8014ic0TYB
00=:<Bf;48@00Q2400<<Ha2448@00a2400D<Ha2448@@Q0aS00@@Q00436<@Q12436<348@00`aS48@@
Q00948@00`aSF]Ioo`05Ool00fmK48@@Q008Ool00f]J48@]J`07Ool00b4848A>L`0EOol00gNm48@<
H`08Ool00acW36<<H`0536<00bU;Oomoo`06Ool3BU801TicBU9BU36<36=[FPMoo`03>LhLif<H00Qo
o`076<H<H`aS36<48@aS:D/03Goo0PaS00@48@aS36<<H`848@03?Nmoogoo00Qoo`03G_L<H`@Q00]o
o`8<H`07124<H`@Q36<48@aS12400PaS00h48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS0@@Q0002
48@236<0112436<@Q1240PaS1A240PaS0a2400@<Ha2448@<H`<@Q00436<@Q12436<748@01`aS48@@
Q0aS:34d]VLL009oo`09L]eEnRdE314L53PF=1Dh5CPF008d5@06>1Dh5S@E=1Dh5CPF0S@E00Hh5CPF
=1Dd5CPE>1H2>1D02cag?9MAFRe[36<DYAcR48@<H`dT36<010S500DLhSdP?B0m81cR00Pm800;AL5=
@4h0<D<HJBQ34>X5TT@7B04l00021I803DP1:>PaSCQS1</hQf6SH/ER@dhQ7V1>Le:D009>L`07BU9>
LdYB:D/<Ha2436<00Q2400<<Ha2436<00a2400L<Ha2448@@Q0aS48@<H`0248@010aS48@@Q0aS0a24
00`<Ha2436<@Q0aS48@<Ha2436<@Q0aSJeX6Ool017=l36<<He[F1goo00<aS0aS;F/01goo00<]Ja24
36<05Goo00<U:@aS36<027oo00<Li`aS36<01@aS00<U:GooOol037oo00=S60aSJeX04Woo00<<H`@Q
36<010aS37oo00=S60@Q36<00PaS00D48@aS36<<Hb4800Yoo`04=Jd48@aSBU8:Ool02@aS124<H`@Q
36<48@aS124<H`0212403PaS124<H`@Q36<48@aS124<H`@Q36<48@aS124136<0008<H`8@Q00736<@
Q0aS36<@Q0aS48@010aS0Q240`aS00@@Q0aS36<@Q0<<H`8@Q00936<@Q12448@<Ha2436<@Q0aS008@
Q00736<@Q3PC=1DL52dEEOX00Woo00Eg_FLL?AL`=3PF008d5@06>1Dh5S@E=1Dh5CPF0S@E00lh5CPF
>1Dd5CPE>1Hd5CPE=1Dh5SbG@9MAFRU;36<00QBU00D@Q0aS36<<H`dT00<8a@0336<X`c5300Pm8004
>6<m84e0AL42CD0054G1;DL14@FB>6<hQbQ31OH5TRe7=BMP0A@888]=iVJRCP0NH08V0LL2DY@4CW<0
1Tib;H/<Ha2436<@Q08<H`0348@<Ha2400<<H`0648@<H`aS48@<Ha240PaS00D@Q0aS36<<Ha24008<
H`0748@<Ha2436<@Q0aS48@00PaS00<@Q0aSOol01Woo00ANm`aS48@U:@Moo`0336<@Q0aS00Moo`04
BU8<Ha24<H`COol016<H36<<H`aS27oo00<HaPaS36<01@aS00<YBgooOol037oo00=>L`@QJeX04Goo
00UBU0@Q36<<H`@Q36<48@aSHaP02goo00XU:@aS124<H`@Q36<48@aS124DY@Yoo`848@0336<DYGoo
00Qoo`09Mkd48@aS124<H`@Q36<48@aS00848@0636<48@aS124<H`@Q0PaS0P@Q00D<H`@Q36<48@aS
00448@0000L<Ha2436<<Ha2436<@Q00536<00a2436<@Q00236<01A2436<@Q0aS48@00PaS00<@Q0aS
48@00PaS00X@Q0aS48@<Ha2436<@Q0aS48@<H`8@Q00536<`=3PF<3@L5002314013bGOomoog=N0S0d
0SPF00Pd5CPE=1Dh5S@E>1Dd5CPF0c@E01<h5S@E>1Dd5CPE>1Hh5Cag@9MAFRe[48@<Ha247>8@Q0aS
2<D<H`022<D01AcR:4<X@cdP<D<013dP00<X`cdP?B000SdP00=5`De0AL400de001=<PSdP:8LPjBf;
0NhTbf6SF68hHaQY;F]>8BI70Nh1SPFB2M=BL`02CW<2BU800dic98dX<@0236<0312436<<Ha2436<@
Q0aS48@<Ha2436<@Q08<H`0848@<H`aS48@<Ha2436<@Q08<H`0448@<H`aS48@236<01Q2436<<Ha24
36<@Q0Moo`04G_L<H`aS36<6Ool016mK36<<H`aS1goo00ES60aS36<<Hd8@015oo`03Mkd<H`aS008<
H`Qoo`036>L<H`aS00D<H`03:D]oogoo00aoo`03DY@<Hf]J015oo`8<H`03124<H`aS008<H`03124Q
27oo00Yoo`0:36<48@aS124<H`@Q36<48@aS124:Ool010@Q36<48@@Q2Goo00I[FP@Q124<H`@Q36<2
12400`aS124<H`02124010aS12448@aS0P@Q00<<H`@Q36<00P@Q0@aS0@@Q0@@Q000L36<0612436<@
Q0aS48@<Ha2436<@Q0aS48@<Ha2436<X<DSi<STH4d4GCQUNW6LLBWMcGP8`=00<>1Dd5CPF=1Dh5C@E
>1Hd5CPE=1Dh5SPE0S@E00@h5S@E>1Hd5@8h5@04?7M0Ue5J:D/248@010aS5:DDYAcR0PaS00X8aAC5
:4<LhRQ3124m8353?B0a@`Hm8095`@E=@00BC8980DP1JL0VAbR7AL4hHa@89</IJ`6>0A4ImSIECSAB
U59c0Tic00=>LTicCW<00RPa00<@Q0aS36<08PaS00<Q27ooOol01Goo00E:DPaS36<<HeJe00Eoo`04
?Nl<H`aS36<7Ool00g=l36<<H`0236<00cW>Oomoo`0=Ool00f<H36<<H`0336<8Ool00aS636<<H`05
36<00bDYOomoo`0<Ool00e:D125[FP0@Ool00`aS124<H`0236<00`@Q36<<H`0236<:Ool02E:D124<
H`@Q36<48@aS124<H`0212400gNmOomoo`06Ool01Tic36<48@aS125S60Qoo`07CW<<H`@Q124<H`@Q
36<00P@Q00<<H`@Q36<00P@Q00@<H`@Q124<H`848@0336<48@aS00848@4<H`448@008`aS00<@Q0aS
36<010aS00hX<CBfMkebgFLLAMTa=Q`D315NW4TH<3@h5S@E0SPE010h5S@E>1Dh5CPF=1Dh5C@E>1Hd
5CPE=1Dh5C@E>1HhM@8lM`03DEXYBa24008@Q00330L@Q12400<@Q007:4<X`bQ3:4<LhRQ3:<<01cdP
00E=@4G1CD1=@4h0009=@00CG@5<PTb2B05HHQiPAL4DaBR788/]JbB=:8Ll05:DG_MF]E9cDY@00dic
00A:DTic98dH42D<H`03?Nmoogoo00Eoo`05@Q0<H`aS36<]J`05Ool436<8Ool536<00aBUF]Ioo`0:
Ool00gNm:D/<H`0536<8Ool00acW36<<H`0336<00`@Q36<]J`0>Ool00eJe36=cO00>Ool02UJe124<
H`aS124<H`@Q36<48@aS0P@Q00=S67ooOol01goo0P@Q00X<H`@Q36<48@aS124<H`@Q36=S60Qoo`03
7>L48@aS00848@03;F]oogoo00Ioo`04?Nl48@aS36<312400`aS12448@02124010aS12448@aS0P@Q
00<<H`@Q12400P@Q00<<H`@Q12400@@Q000Z36<012PaBAQW71db0Q`D0S@E00<h5RRD>1D00c@E00Dh
5S@E=1Dd5CPF00<d5@0>>1Hd5CPE>1Hd5CPF=1Dh5S@E>1HlMd2GDEXYB`8@Q00836<@Q12448@DYA24
:4<@Q0<LhP8X@`037>8X@c5300@m809=@003AL5>04h000E=@0980@0<E0Dm81dT50PhQbR798da@fW0
:8M:MeJe14ic0TYB00A:<DYB98dTSBD<H`03=JeS65[F009F]@04F]IF]F<H;F/436<01EJeG_MF]F<H
BU8010aS00=6<EkgE[D015Je00=[FPaS36<01PaS00<mkgNmOol01Goo00=BU1S636<010aS00<48@aS
36<00Woo17Nm0Woo00<HaPaS12400PaS00@48@aS36<YB`9oo`Eg_@03Oomg_GNm00=g_@05Oom>L`@Q
HaQoo`02Mkd00gooMkeg_@02Mkd2Ool02V<HDY@]J`@Q36<48@aS124<H`@Q0PaS00D48@aS124<Hbe[
009oo`Eg_@06Oom_F`@Q36<48@aS0P@Q00T<H`@Q124<H`@Q?NmoogNmOol00WNm00=oogNmOol00`@Q
00<<H`@Q48@00Woo00Mg_GooMkeoogNmOolQ200512401PaS12448@aS124<H`848@0436<48@@Q36<2
12400`aS124<H`02124136<11240000336<48@aS00L<H`03124<H`aS008<H`05124<H`aS36<48@0F
36<01BPa?9Ld]Q`D>1H00S@E00Lh5S@E51Hh5S@E>1Hh5@02=1D023PF>1Dd5C@E>1Hh5C@E>1H2=1D0
3cPE=1Dh5C@E>1Hh5Cag@9MAFRU;36<@Q0a848@<H`0348@00acR:4<X@`06:4<022R7;F/e9d75DP/a
PcdPAL46CD000ed1C8980@02:4<02Q@8:8LXQbC;6FiY`4DX>6=F]E:D0dic00=>LTHaAS400THa00<Y
BaS636<00`aS00<48@aS36<02@aS00<48@aS36<00`aS00<48@aS36<03PaS00<48@aS36<00PaS00<4
8@aS36<01@aS00<48@aS36<04@aS00<48@aS36<01PaS00<48@aS36<00PaS00<48@aS36<01@aS00D4
8@aS36<<H`@Q00T<H`05124<H`@Q36<48@0436<00`@Q36<<H`0236<00`@Q36<48@0336<02@@Q36<4
8@aS124<H`@Q36<48@0236<020@Q36<48@aS124<H`@Q36<212401@aS124<H`@Q36<00P@Q0PaS00P4
8@aS124<H`@Q36<48@aS0P@Q00@<H`@Q124<H`848@0536<48@@Q124<H`02124010aS12448@aS0P@Q
00<<H`@Q12401@@Q00L<H`@Q36<48@aS124<H`0212400`aS12448@0612400`aS124<H`0412400`aS
12448@01124000<<H`04124<H`aS124636<00`@Q36<<H`0536<00`@Q36<<H`0336<00`@Q36<<H`0<
36<01cPC=1D`=3PF=1Dh5S@E00@h5P8h5@03=1Dh5SPE008d5@07>1Hh5C@E=1Dh5S@E>1H00S@E00<h
5S@E>1H00SPE0T2G00=AFRU;48@010aS112400<DYBS35:D00RS300XmCC6<>Lhmkd8@=JliZ4W>@LDm
80=>0095`@0@CD0m83QS?00DYAS6A0LXQbSX98dYB`6>HJ=D1A@8E[D3?Nl01CW>:D/<H`aS124010aS
00<48@aS36<00`aS00@48@aS36<48@<<H`03124<H`aS008<H`03124<H`aS00@<H`03124<H`aS008<
H`03124<H`@Q00L<H`03124<H`aS008<H`03124<H`aS00L<H`03124<H`@Q00@<H`03124<H`aS008<
H`03124<H`@Q00<<H`04124<H`aS124536<00`@Q36<<H`0236<00`@Q36<48@0536<01`@Q36<<H`aS
124<H`@Q008<H`03124<H`aS00<<H`07124<H`@Q124<H`@Q36<00P@Q00D<H`@Q36<48@aS00848@8<
H`08124<H`@Q36<48@aS124<H`848@0;36<48@aS124<H`@Q36<48@aS124<H`0212400`aS124<H`03
12400`aS124<H`0312400`aS124<H`0212401@aS124<H`@Q36<00P@Q00@<H`@Q124<H`848@0436<4
8@@Q36<312401@aS124<H`@Q36<020@Q00D<H`@Q12448@aS00<48@0336<48@@Q00D48@0536<48@@Q
124<H`0112400003124<H`aS00H<H`04124<H`aS124236<010@Q36<<H`@Q1@aS00<48@aS124010aS
00<48@aS12400`aS00<48@aS36<00PaS00XX<CPF>1Hd5CPF>1Dh5S@E>1Hh5@8d5@06>1Hd5CPE=1Dh
5SPE0S@E00Lh5S@E=1Dh5C@E>1Dh5P03=1D033PE>7DlMcagDEXYB`aS48@<Ha245:DLi`8U:@0:7>L]
Jbf;;DLXj3DW;F/]RdDX;DL2:<<00acW=BL48@02:4<01BS3:4<X@cQS:4<012R700e41bR7:8LHJB2;
CR4IJbS3>8LU:AdY36<48@0736<00`@Q36<<H`0236<010@Q36<<H`@Q1@aS00D48@aS36<<H`@Q00@<
H`04124<H`aS124336<00`@Q36<<H`0436<00`@Q36<48@0536<00`@Q36<<H`0236<010@Q36<<H`@Q
0PaS00<48@aS36<00`aS00<48@aS36<00PaS00<48@aS36<010aS00D48@aS36<<H`@Q00<<H`03124<
H`aS008<H`03124<H`@Q00@<H`03124<H`@Q00<<H`848@8<H`09124<H`@Q36<48@aS124<H`@Q00D<
H`09124<H`aS36<48@aS124<H`@Q008<H`848@0;36<48@aS124<H`@Q36<48@aS124<H`0212400`aS
124<H`03124010aS12448@aS0`@Q00<<H`@Q36<00`@Q00<<H`@Q36<00`@Q00<<H`@Q12401@@Q00<<
H`@Q12401@@Q00D<H`@Q12448@aS00P48@0536<48@@Q124<H`0312401@aS12448@@Q36<010@Q00@<
H`@Q124<H`<48@0336<48@@Q00448@000PaS00T48@aS124<H`@Q36<48@aS12400`aS00@48@aS36<4
8@<<H`03124<H`@Q00D<H`03124<H`aS00<<H`05124<H`aS36<48@0236<00cPC>1Hh5@02=1D00cPE
=1Dh5P02=1D01SPE>1Hd5CPE=1Dh5P<d5@03>1Hh5CPF008d5@05>1Hd5CPE>1Hd5@03>1H033bG@9MA
FRU;36<@Q0aS8>TU:Be[9BTe[@8U:@07?DdXj1cR;F/e9bQ3124032Q3014D22Q3:4<X@bR7:4<XQaBU
7>LDYA2436<48@aS124<H`@Q008<H`05124<H`@Q36<48@0336<00`@Q36<48@0236<01P@Q36<<H`@Q
36<48@@<H`06124<H`aS124<H`@Q0PaS00D48@aS36<<H`@Q008<H`05124<H`@Q36<48@0336<01@@Q
36<48@aS12400PaS00D48@aS124<H`@Q00<<H`07124<H`aS36<48@aS12400PaS00<48@aS12400PaS
00d48@aS124<H`@Q36<48@aS124<H`@Q36<48@0236<00`@Q36<48@0336<02P@Q36<48@@Q36<48@aS
124<H`@Q0`aS00@48@aS36<48@8<H`06124<H`@Q36<48@aS10@Q00D<H`@Q12448@aS00848@0536<4
8@@Q124<H`02124020aS12448@aS124<H`@Q36<212401`aS12448@@Q36<48@aS00848@0536<48@aS
124<H`0412400`aS12448@0312400`aS12448@02124010aS12448@aS0`@Q00D<H`@Q12448@aS00T4
8@0436<48@@Q36<312400`aS12448@0G124000848@0336<48@aS008<H`07124<H`@Q36<48@aS1240
0PaS00L48@aS124<H`@Q36<48@0236<00`@Q36<48@0236<010@Q36<<H`@Q0`aS00H48@aS36<48@aS
:342<3@02cPE>1Hd5CPE>1<d5CPE=1Dh5C@E>1H00SPE00<d5CPF>1D00S@E00Ph5CPF>1Dd5CPF=1Dh
5C@E0cPE00LlMd2GDEXYBa2436<@Q0028>T01RDY8>TU:A2436<48@8X@`0348@X@acR00/X@`04:8LX
@bQ3:4<248@236<01@@Q36<48@aS12400PaS00<48@aS12400PaS00/48@aS124<H`@Q36<48@aS124<
H`@Q008<H`07124<H`aS124<H`@Q36<00P@Q00L<H`@Q36<<H`@Q36<48@0236<01@@Q36<48@aS1240
0PaS00<48@aS12400`aS00D48@aS124<H`@Q008<H`0;124<H`@Q36<48@aS124<H`@Q36<48@0236<2
12401`aS124<H`aS124<H`@Q008<H`0=124<H`@Q36<48@aS124<H`@Q36<48@aS12400PaS00T48@aS
124<H`@Q36<48@aS12400PaS00X48@aS124<H`@Q36<48@aS124<H`848@0636<48@@Q36<48@aS0`@Q
10aS00H48@aS124<H`@Q36<212401@aS124<H`@Q36<00P@Q00<<H`@Q124010@Q00H<H`@Q124<H`@Q
36<312400`aS12448@06124010aS12448@aS0P@Q00D<H`@Q12448@aS03P48@000PaS00/48@aS1244
8@aS124<H`@Q36<48@aS00848@0836<48@aS36<48@aS124<H`848@0436<48@aS124236<01P@Q36<<
H`@Q36<48@8<H`03124<H`@Q008<H`8HJ@0388/X<BPa008`=005=1Dh5SPF>1D`=002=1D013PF=1Dd
5CPF0c@E01<h5CPF=1Dh5S@E>1Hd5CPF>1DlMd2GDEXYB`S636<HaQSW48@DY@0248@01RQ348@LhQ24
:4<<H`TX@`0648@X@`aS48@48@aS0P@Q00@<H`@Q36<48@8<H`06124<H`@Q124<H`@Q0PaS00L48@aS
124<H`@Q36<48@0236<010@Q36<48@aS0P@Q00H<H`@Q36<48@aS124336<02P@Q36<48@@Q36<48@aS
124<H`@Q0PaS00L48@aS12448@aS124<H`0212401@aS124<H`@Q36<00P@Q0PaS00T48@aS36<48@aS
124<H`@Q36<00P@Q0PaS00H48@aS12448@aS124236<02@@Q36<48@aS124<H`@Q36<48@0236<010@Q
36<48@aS0P@Q00P<H`@Q36<<H`@Q36<48@aS0P@Q00L<H`@Q36<48@aS124<H`0212401@aS124<H`aS
12400PaS00<48@aS12400PaS1`@Q00D<H`@Q12448@aS00848@0536<48@@Q124<H`0212401@aS124<
H`@Q36<00P@Q00@<H`@Q124<H`848@0436<48@@Q36<2124010aS12448@aSA0@Q000212402`aS124<
H`aS124<H`@Q36<48@aS12400PaS01848@aS12448@aS124<H`@Q36<48@aS124<H`@Q36<48@aS1243
36<00`@Q36<48@0336<02P@Q36<<H`aS124<H`@Q36<@Q1BU0QQY00PTSBPa:34h4c0d>1Dh5S@E0SPE
0c@E00@h5C@E>1Dd5@8h5@05>1HlMd2GDEXYB`0236<010`736<<H`aS112400PX@`aS:4<LhRQ348@D
YA241@aS0P@Q00@<H`@Q36<48@8<H`04124<H`@Q36<212401PaS124<H`aS124<H`848@0736<48@aS
124<H`@Q36<00P@Q00@<H`@Q36<48@8<H`06124<H`@Q36<48@aS0`@Q00X<H`@Q36<<H`@Q36<48@aS
124<H`848@0736<48@aS36<48@aS12400PaS00D48@aS124<H`@Q008<H`848@0936<48@@Q36<48@aS
124<H`@Q008<H`848@0636<48@aS36<48@aS0P@Q00L<H`@Q36<48@aS124<H`04124010aS124<H`@Q
0PaS00P48@aS12448@aS124<H`@Q0PaS00@48@aS124<H`<48@0336<48@@Q00`48@0536<48@aS124<
H`0212400`aS124<H`02124010aS12448@aS0`@Q00<<H`@Q1240F@@Q00000`@Q36<48@0712400`aS
12448@0512400`aS12448@0312402@aS12448@@Q36<48@aS124<H`0312400`aS124<H`03124236<3
12401@aS124<H`@Q36<010@Q0PaS00L@Q1@86>LPRbB=:34h4`04>1H2>1D02S@E>1Dh5Cag@9MAFRe[
36<8aPS50PaS0Q2400DDYA2448@DYA2400<<H`T48@0336<48@@Q00T48@0336<48@@Q00D48@0336<4
8@@Q00<48@0436<48@@Q36<<12400`aS124<H`0;12400`aS12448@0912400`aS12448@03124010aS
12448@aS0`@Q00<<H`@Q12400`@Q00<<H`@Q12401@@Q00<<H`@Q12400`@Q00H<H`@Q124<H`@Q36<9
12400`aS12448@0912403PaS12448@aS124<H`@Q36<48@aS124<H`@Q36<212400`aS12448@1]1240
00848@0736<48@aS124<H`@Q36<00P@Q014<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS
00848@0636<48@@Q36<48@aS0`@Q00<<H`@Q36<00P@Q00D<H`@Q36<48@aS00<48@0<36<48@aS124<
H`@Q36<48@aS124<H`@Q0PaS00L@Q1BU88/TSBPa>7Dl]@02>7D0242GEOXYBa2436<8aA2436<248@0
0`@Q36<48@0512409@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<4
8@aS124<H`@Q36<48@aS124<H`@Q36<48@aS00848@0=36<48@aS124<H`@Q36<48@aS124<H`@Q36<0
0P@Q01l<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<4
8@aS124<H`0212406@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<48@aS124<H`@Q36<4
8@aS00H48@0736<48@aS124<H`@Q36<00P@Q00T<H`@Q36<48@aS124<H`@Q36<00P@Q00<<H`@Q1240
O0@Q000L124010aS12448@aS0P@Q00@<H`@Q36<<H`848@0336<48@aS00848@0536<48@@Q124<H`0G
12401PaS5:DHJASW48@<Hol48AP48@007P@Q00@<H`@Q124<H`D48@0336<48@@Q00848@0436<48@@Q
36?o124A12400`0012448@0S12400?l48BP48@0300048@@Q01448@0300048@@Q00d48@0300048@@Q
01848@0300048@@Q00<48@00o`@Q:P@Q00@000@Q124000<48@0300048@@Q00`48@0500048@@Q1240
000B12401P0012448@00124000T48@400000o`@Q4@@Q00D000@Q12448@0000<48@0500048@@Q1240
000912400`0012448@0912402P0012448@00124000@Q00048@001@@Q00<000@Q12400P@Q00D000@Q
12448@0000@48@0300048@@Q00848@0300048@@Q00H48@0300048@@Q00H48@001`@Q00<000@Q1240
:P@Q00<000@Q12400P@Q00D000@Q12448@0000H48@0500048@@Q1240000<12400`0012448@071240
0`0012448@051240100012448@0020@Q00@000@Q124000/48@0300048@@Q00L48@0400048@@Q0002
12400`0012448@0212400`0012448@0412400`0012448@0412400`0012448@0312400`0012448@04
1240100012448@007`@Q00<000@Q12400`@Q00<000@Q12400P@Q00D000@Q12448@0000@48@030004
8@@Q00@48@0400048@@Q000512400`00124000041240100012448@001@@Q00D000@Q12448@0000@4
8@0500048@@Q124000031240200012448@@Q00048@00124200001`@Q00048@@Q00048@0000848@05
00048@001240000212401@0012448@@Q00000`@Q00T000@Q00048@00124000@Q00000`@Q00L000@Q
12448@001240000212400`001240000212401@00124000@Q000010@Q00H000@Q00048@0012410000
000500048@@Q1240000412400`001240000512400`0012448@021240100012448@0060@Q00<000@Q
12400P@Q00<000@Q12401@@Q00@000@Q124000T48@0400048@@Q000212400`0012448@0412401@00
124000@Q000010@Q00@000@Q124000L48@0400048@@Q000812400`001240000212400`0012448@07
12400`0012448@0:12400`0012448@0312400`0012448@0412400`0012448@0412401@0012448@@Q
00000P@Q00<000@Q124010@Q00@000@Q124000@48@0600048@@Q00048@001P@Q00X000@Q124000@Q
00048@00124000848@0300048@0000<48@0300048@@Q00848@0500048@@Q1240000412400`001244
8@0812400`001240000412400`001240000212401`00124000@Q00048@0000<48@0F00048@@Q0004
8@00124000@Q00048@00124000@Q00048@00124000@Q000312402@00124000@Q00048@0012400002
12401@001240000012400`000P@Q0P0001848@00124000@Q00048@00124000@Q00048@00124000@Q
000212401000124000@Q0P0000@48@00124000848@0700048@00124000@Q00000`@Q000312401`00
124000@Q00048@0000848@0400048@000003124200021240100012448@000P@Q00<000@Q12400P@Q
00<000@Q12401`@Q00<000@Q12401@@Q0P000`@Q00P000@Q000000@Q00048@000P@Q00<000@Q0000
0P0000<48@0000000`@Q00<000@Q00000P@Q00X000@Q124000@Q00048@00124000848@0300048@00
00848@0400048@00124200001@@Q00048@@Q00000P@Q00P000@Q000000@Q00048@000`@Q00`000@Q
124000@Q00048@00124000@Q000212401@0012448@0012400P0000L48@00124000@Q00048@020002
12401P0012400000124000848@0900048@00124000@Q00048@0000848@0400048@00124200000`@Q
00048@02000212401@00124000@Q00001@@Q00D000@Q00048@0000848@0600048@@Q00048@000P@Q
00<000@Q12400P@Q00@000@Q00048@800003124000@Q008000848@0600048@0000048@000P@Q00L0
00@Q00048@001240000312401`0012400000124000@Q0080000;124000@Q00048@00124000@Q0004
8@0200004`@Q00048@00124000@Q00048@00124000@Q00048@00124000@Q00<00005124000@Q0004
8@03000010@Q000000@Q0P0000D48@00124000@Q0080000412400000124200004@@Q000000@Q0004
8@00124000@Q00048@00124000@Q00000P@Q00d000@Q12448@00124000@Q00048@00124000021240
0`00124000010000000300048@0000848@0600048@@Q00048@001@@Q0P000`@Q00H000@Q124000@Q
000512401`0012448@@Q00048@0000<48@0500048@@Q1240000312401`0012448@@Q00048@0000H4
8@0300048@0000T48@800004124000@Q124200002`@Q000000@Q00048@00124000@Q00000P@Q00<0
00@Q00001`@Q00<000@Q00000P@Q00<000@Q12401@@Q00@000@Q000000848@0400048@@Q00021240
2P0012448@00124000@Q00048@0020@Q00<000@Q12400P@Q00<000@Q12401@@Q0P0000D48@001244
8@0000848@0300048@0000L48@0300048@@Q00848@800003124000@Q00848@0400048@0000021240
1@00124000@Q00000P@Q0P0000@48@00124000848@0300048@0000848@0300048@@Q00848@030004
8@@Q00848@0300048@@Q00@48@0500048@001240000212400`0012448@0200001@@Q00048@@Q0000
0P@Q00<000@Q00000P@Q00H000@Q00048@00124200008`@Q00048@00124000@Q00048@00124000@Q
00048@00124000@Q00048@00124000@Q00048@00124000@Q00048@0012400P0000P48@0000048@00
124000@Q0P0000@48@0000048@800005124000001240000212400`0012448@02000010@Q000000@Q
0P0000@48@0000048@80000412400000124200001P@Q000000@Q00048@4000001@0000<48@000000
2@0000@48@0000048@80000J12400000124000@Q00048@00124000@Q00048@00124000@Q00048@00
124000@Q00048@h000031240000000T00004124000001242000010@Q000000@Q5@0000<48@000000
2P0000@48@0000048@800004124000001242000010@Q000000@Q0`0000<48@000000200000<48@00
00002P0000@48@0000048@80000412400000124900000`@Q00000002000010@Q000000@Q0P0000D4
8@00000000@Q0080000412400000124E00000`@Q0000000900001@@Q0000000012400P0000@48@00
00048@80000412400000124200000`@Q0000000900000`@Q0000000g000010@Q000000@Q0P0000@4
8@0000048@800004124000001242000010@Q000000@Q0P0000@48@0000048@8000448@4000400000
7@0001D48@00124000@Q00048@00124000@Q00048@00124000@Q00048@001240o`00=@00003o001W
00000?l006L00000o`00I`00003o001W00000001

\
\>"], "Graphics",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  CellLabelMargins->{{1, Inherited}, {Inherited, Inherited}},
  CellFrameMargins->False,
  ImageSize->{358, 193},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[0],
  CellTags->"Top"],

Cell[TextData[{
  StyleBox[ValueBox["$FullVersion"],
    FontWeight->"Bold"],
  "\nRegistered Name: ",
  ValueBox["$RegistrationUserName"],
  "\nOrganization: ",
  ValueBox["$RegistrationOrganization"],
  "\nLicense ID: ",
  ValueBox["$LicenseID"]
}], "TopMatter",
  CellTags->"Top"],

Cell[TextData[{
  "\[Copyright] Copyright 1988-1996 Wolfram Research, Inc. Protected by \
copyright law and international treaties. Unauthorized reproduction or \
distribution subject to severe civil and criminal penalties. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a registered trademark of Wolfram Research. This About Box is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook.\n\n\n\n\n"
}], "TopMatter",
  LineSpacing->{1, -1},
  CellTags->"Top"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"ContactInformation",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["Contact Information", "SectionHeading",
  CellTags->"ContactInformation"],

Cell[CellGroupData[{

Cell["Main Web Sites", "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[StyleBox[
"http://www.wolfram.com\nhttp://www.wolfram.co.uk\nhttp://www.wolfram.co.jp\n\
\nNote: All services listed are available at all of these sites.",
  FontColor->GrayLevel[0]]], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Information about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["General and sales information\n",
    FontWeight->"Bold"],
  "info@wolfram.com\nhttp://www.wolfram.com\n\n",
  StyleBox["Frequently asked technical and other questions\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/faq\n\n",
  StyleBox["Documentation updates\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/book-updates"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Services for Users",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["User registration and password requests\n",
    FontWeight->"Bold"],
  "register@wolfram.com\nhttp://www.wolfram.com/register\n\n",
  StyleBox["Technical support and bug reports\n",
    FontWeight->"Bold"],
  "support@wolfram.com\nhttp://www.wolfram.com/support\n\n",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" training information\n",
    FontWeight->"Bold"],
  "training@wolfram.com\nhttp://www.wolfram.com/training"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Comments and Feedback",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Suggestions\n",
    FontWeight->"Bold"],
  "suggestions@wolfram.com\nhttp://www.wolfram.com/suggestions\n\n",
  StyleBox["Bug reports\n",
    FontWeight->"Bold"],
  "support@wolfram.com\nhttp://www.wolfram.com/support\n\n",
  StyleBox["Comments and feedback\n",
    FontWeight->"Bold"],
  "comments@wolfram.com\nhttp://www.wolfram.com/comments\n\n",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Archive\n",
    FontWeight->"Bold"],
  StyleBox[
  "Publications and other nonproprietary Mathematica related \nmaterial  is \
welcome at: \n",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox["\n",
    FontSize->9],
  StyleBox["The ",
    FontSize->10],
  StyleBox["Mathematica",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox[
  " Archive\nWolfram Research, Inc.\n100 Trade Center Drive\nChampaign, IL \
61820, USA",
    FontSize->10],
  "\n",
  StyleBox["\n",
    FontSize->9],
  "archive@wolfram.com\nhttp://www.wolfram.com/archive"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["-Related Products \nand Material",
    FontSize->14,
    FontWeight->"Bold"]
}], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Products Catalog\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/catalog\n\n",
  StyleBox["The ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Book\n",
    FontWeight->"Bold"],
  "book-updates-responder@wolfram.com\nhttp://www.wolfram.com/book-updates\n\n\
",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Bookstore\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/bookstore\n",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["MathSource",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Electronic Library\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/mathsource\nftp: mathsource.wolfram.com\nmail \
server: mathsource@wolfram.com\nadministrator: mathsource-admin@wolfram.com",
  StyleBox["\n\n",
    FontWeight->"Bold"],
  StyleBox["MathUser ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Newsletter\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/mathuser\nmathuser@wolfram.com"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Company Addresses",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Wolfram Research, Inc.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\n100 Trade Center Drive\nChampaign, IL 61820\nUSA\nemail: \
info@wolfram.com\nphone: 217-398-0700\nfax: 217-398-0747\n\n",
    FontColor->GrayLevel[0]],
  StyleBox["Wolfram Research Europe Ltd.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\n10 Blenheim Office Park\nLower Road, Long Hanborough\nOxfordshire OX8 \
8LN\nUNITED KINGDOM\nemail: info@wolfram.co.uk\nphone: +44-(0)1993-883400\n\
fax: +44-(0)1993-883800\n\n",
    FontColor->GrayLevel[0]],
  StyleBox["Wolfram Research Asia Ltd.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\nIzumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101\nJAPAN\n\
email:  info@wolfram.co.jp\nphone: +81-(0)3-5276-0506\nfax: \
+81-(0)3-5276-0509",
    FontColor->GrayLevel[0]],
  "\n"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"Credits",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["Credits", "SectionHeading",
  CellTags->"Credits"],

Cell[TextData[{
  StyleBox["Original concept by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Front end concept by: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\n\n",
  StyleBox["Kernel language design by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Version 3.0 kernel lead developers:",
    FontWeight->"Bold"],
  "\nVictor Adamchik\nAlexei Bocharov\nJerry Keiper\nRob Knapp\nDan Lichtblau\
\nBo Liu\nMark Sofroniou\nSirpa Saarinen\nAdam Strzebonski \nTom \
Wickham-Jones\n\n",
  StyleBox["Additional senior kernel developers:",
    FontWeight->"Bold"],
  "\nRoman Maeder\nOleg Marichev\nBruce K. Smith\nMichael Trott\nDavid \
Withoff\nStephen Wolfram\n\n",
  StyleBox["Front end language design by: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\nNeil Soiffer\nStephen Wolfram\n\n",
  StyleBox["Macintosh lead developer: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\n\n",
  StyleBox["Microsoft Windows lead developer: ",
    FontWeight->"Bold"],
  "\nTom Sherlock\n\n",
  StyleBox["X Window System lead developer: ",
    FontWeight->"Bold"],
  "\nJohn Cwikla\n\n",
  StyleBox["NeXT lead developers: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\nChris Carlson\n\n",
  StyleBox["Additional front end developers:",
    FontWeight->"Bold"],
  "\nJohn Brewer\nThomas Chin\nJohn Fultz\nTodd Gayley\nMike Rasberry\nDoug \
Stein\nDavid Stes\n\n",
  StyleBox["Expression formatting lead developer: ",
    FontWeight->"Bold"],
  "\nNeil Soiffer\n\n",
  StyleBox["Additional expression formatting developers:",
    FontWeight->"Bold"],
  "\nJeff Adams\nRobby Villegas\nTom Wickham-Jones\n\n",
  StyleBox["MathLink lead developer: ",
    FontWeight->"Bold"],
  "\nShawn Sheridan\n\n",
  StyleBox["Standard packages development coordinator: ",
    FontWeight->"Bold"],
  "\nEmily Martin\n\n",
  StyleBox["Lead package developers:",
    FontWeight->"Bold"],
  "\nJerry B. Keiper\nRoman Maeder\nEmily Martin\nJohn Novak\nSteven Skiena\n\
Mark Sofroniou\nAdam Strzebonski\nDavid Withoff\n\n",
  StyleBox["Additional package developers:",
    FontWeight->"Bold"],
  "\nVictor Adamchik\nJeff Adams\nAlexei Bocharov\nGeorge Beck\nMichael Chan\n\
Arun Chandra\nYu He\nDavid Jacobson\nJason Kastner\nRobert Knapp\nMatthew \
Markert\nKevin McIsaac\nMarko Petkovsek\nSirpa Saarinen\nMichael Trott\nIlan \
Vardi\nAudra Wenzlow\nTom Wickham-Jones\nStephen Wolfram\nEran Yehudai\n\n",
  StyleBox["Software engineering managers: ",
    FontWeight->"Bold"],
  "\nRory Murtagh\nSam Roseman\n\n",
  StyleBox["Lead software engineers: ",
    FontWeight->"Bold"],
  "\nRon Fisher\nChris LaReau\nOleg Perelet\nLeland Ray\nPatrick Rice\nMonte \
Seyer\nMakoto Tanabe\n\n",
  StyleBox["Additional software engineers:",
    FontWeight->"Bold"],
  "\nDan Brumleve\nDavid Karner\nChris Lindsey\nPat McGraw\nEd Thomson\nGene \
Van Nostern\n\n",
  StyleBox["Quality assurance manager: ",
    FontWeight->"Bold"],
  "\nScott Midler\n\n",
  StyleBox["Quality assurance lead engineers: ",
    FontWeight->"Bold"],
  "\nJeff Blankenship\nLarry Calmer\nLou D'Andria\nKaren Fernsler\nAnna \
Marichev\nBob Naiman\nMatthew Markert\n\n",
  StyleBox["Additional quality assurance staff/contributors:",
    FontWeight->"Bold"],
  "\nBryce Austin\nScott Brown\nJay Hawkins\nKevin Leuthold\nPatty Merkin\n\
Rolf Mertig\nCourtney Wirth\nJamie Peterson\nJill Smith\n\n",
  StyleBox["Additional senior technical staff:",
    FontWeight->"Bold"],
  "\nIgor Bakshee\nBruce Carpenter\nCetin Cetinkaya\nIan Collier\nRobert \
Dickau\nBen Friedman\nYu He\nBrenda Hunt\nSteve Hunt\nTom Issaevitch\nJohn \
Novak\nTodd Ramsburg\nLeszek Sczaniecki\nLucy Zamiatina\n\n",
  StyleBox["Primary documentation by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Additional documentation by:",
    FontWeight->"Bold"],
  "\nGeorge Beck\nPhilip Boyland\nVicki Bush\nJoe Grohens\nJerry Walsh\nPaul \
Wellin\n\n",
  StyleBox["Editing and production by:",
    FontWeight->"Bold"],
  "\nGeorge Beck\nJoe Kaiping\nJan Progen\nGlenn Scholebo\nPhilip Wall\nJerry \
Walsh\n\n",
  StyleBox["Additional publications staff:",
    FontWeight->"Bold"],
  "\nCaron Allen\nMadhav Chari\nJohn Garvey\nKurt Kessinger\nAngela Latham\n\
Wendy Leung\nCarol Ordal\nLaurie Scoggins\nDoug West\nTimothy Williams\n\n",
  StyleBox["Design director: ",
    FontWeight->"Bold"],
  "\nJohn Bonadies\n\n",
  StyleBox["Graphic designers:",
    FontWeight->"Bold"],
  "\nJody Jasinski\nAndre Kuzniarek\nJennifer Lofgren\nAnn Maroso\nKimberly \
Michael\n\n",
  StyleBox["Lead graphic image creators:",
    FontWeight->"Bold"],
  "\nIgor Bakshee\nGeorge Beck\nMichael Trott\n\n",
  StyleBox["Lead font designer: ",
    FontWeight->"Bold"],
  "\nAndre Kuzniarek\n\n",
  StyleBox["Additional font design by:",
    FontWeight->"Bold"],
  "\nAndy Hunt\nGalapagos, Inc.\nGlenda de Guzman\nY&Y, Inc.\n\n",
  StyleBox["Marketing director:",
    FontWeight->"Bold"],
  "\nJohn Bonadies\n\n",
  StyleBox["Lead product marketing staff:",
    FontWeight->"Bold"],
  "\nHoward Berg\nKatherine Csizmadia\nMonica Davis\nSue Johnson\nCarrie \
Karnopp\nZoe Midler\nClaire Miller\nJon McLoone\nJane Rich\nAlan Skillman\n\
Jelena Spanjol\nChristy Uden\n\n",
  StyleBox["Strategic and international development:",
    FontWeight->"Bold"],
  "\nConrad Wolfram\n\n",
  StyleBox["Overall management:",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n\n",
  StyleBox["Dedicated to the memory of Jerry B. Keiper (1953\[Dash]1995)",
    FontSlant->"Italic"]
}], "CreditsText",
  CellTags->"Credits"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox["\(Contact Information\)",
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox["\(License Agreement\)",
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"LicenseAgreementPrint",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["License Agreement", "SectionHeading",
  CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],

Cell[CellGroupData[{

Cell["ACCEPTANCE", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
CAREFULLY READ THE FOLLOWING TERMS AND CONDITIONS BEFORE OPENING \
THE MEDIA CONTAINER. OPENING THE MEDIA CONTAINER INDICATES YOUR ACCEPTANCE OF \
THE TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU ARE NOT WILLING TO ACCEPT \
THE TERMS AND CONDITIONS OF THIS AGREEMENT, YOU SHOULD RETURN THE ENTIRE \
PRODUCT, WITH THE SEAL ON THE MEDIA CONTAINER UNBROKEN, TO THE PLACE FROM \
WHICH IT WAS OBTAINED FOR A REFUND OF THE PURCHASE PRICE.\
\>", "LicenseText",\

  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["DEFINITIONS", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  StyleBox["WRI:",
    FontWeight->"Bold"],
  " Wolfram Research, Inc.\n\n",
  StyleBox["You/Licensee:",
    FontWeight->"Bold"],
  " The purchaser of this license.\n\n",
  StyleBox["Product:",
    FontWeight->"Bold"],
  " All the materials provided with this License Agreement.\n\n",
  StyleBox["Software:",
    FontWeight->"Bold"],
  " The computer programs enclosed in the media container.\n\n",
  StyleBox["License Certificate:",
    FontWeight->"Bold"],
  " The description that indicates specific information about the license to \
use this Product.\n\n",
  StyleBox["Process:",
    FontWeight->"Bold"],
  " Every time the Software is started, a Process is invoked by Your \
computer's operating system. Some versions allow more than one Process to run \
concurrently. Your License Certificate states the maximum number of \
concurrent Processes that You may run.\n\n",
  StyleBox["Product Name:",
    FontWeight->"Bold"],
  " On the line titled Product, Your License Certificate states the name of \
the Product and the type of computer(s) for which the Product is licensed for \
use.\n\n",
  StyleBox["Product Class:",
    FontWeight->"Bold"],
  " A categorization of different ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " products. Your License Certificate states the Product Class to which this \
Product belongs.\n\n",
  StyleBox["Binary Kit(s):",
    FontWeight->"Bold"],
  " If the Product is being provided with Software intended for use with one \
or more other type(s) of computer(s) in addition to the type of computer(s) \
described in the Product section of Your License Certificate, a section \
titled Binary Kit(s) will be printed on Your License Certificate. The Binary \
Kit(s) section lists the additional type(s) of computer(s) for which Software \
is supplied.\n\n",
  StyleBox["Use Class:",
    FontWeight->"Bold"],
  " A categorization of products based on the ways in which they may be used. \
Your License Certificate states the Use Class to which this Product belongs. \
If there are any restrictions on the use of this Product due to its Use \
Class, the restrictions will be written on the License Certificate.\n\n",
  StyleBox["License Class:",
    FontWeight->"Bold"],
  " A categorization of different ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " licenses that indicates how the Product may be run on a network of \
computers. The License Classes are Single-Machine and Network. Your License \
Certificate states the License Class to which this Product belongs.\n\n",
  StyleBox["Single-Machine License:",
    FontWeight->"Bold"],
  " The Single-Machine License allows one or more users to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a single machine that contains the \"host\" CPU for the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel.\n\n",
  StyleBox["Single-User License:",
    FontWeight->"Bold"],
  " A Single-Machine License for a single user.\n\n",
  StyleBox["Network License:",
    FontWeight->"Bold"],
  " The Network License is designed to accommodate a network environment. A \
server program allows a predetermined number of Processes to run concurrently \
on the network. A Process may be invoked only on a computer associated with \
the same or lesser Product Class as listed on Your License Certificate."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["OWNERSHIP", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
WRI is the sole owner of the Software contained in this package \
with the exception of portions of Software licensed by WRI from other firms, \
which are the owners of those portions.

WRI is the holder of the copyright to the Software, including without \
limitation such aspects of the Software as its code, structure, sequence, \
organization, \"look and feel\", programming language and compilation of \
command names. Use of the Software unless pursuant to the terms of a license \
granted by WRI or as otherwise authorized by law is an infringement of the \
copyright.\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["PERMITTED USES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  "Provided that You accept this License Agreement, WRI grants You a \
non-exclusive license to use the Product. The Software may be run on the \
type(s) of computer(s) described in the Product section of Your License \
Certificate. If there is a Binary Kit(s) section in Your License Certificate, \
You may also use the version(s) of the Software described as being intended \
for use with other types of computers with those other types of computers. If \
your License Class is a Single-Machine License, You are authorized to run \
concurrent Processes up to the maximum number specified on Your License \
Certificate; however, all Processes must run on a single computer. If Your \
License Class is a Network License, You are authorized to run concurrent \
Processes up to the maximum number specified on Your License Certificate, \
provided that all the Processes are run on computers in the same network. \
Your license terminates in the event that You receive a license to use an \
upgraded version of the Product in place of the Product. If a license \
expiration date is printed on Your License Certificate, Your license to use \
the Product terminates on that day. You are also authorized to:\n\n",
  StyleBox["a.",
    FontWeight->"Bold"],
  " install the Software on a single on-line storage device (for example, a \
hard disk drive);\n\n",
  StyleBox["b.",
    FontWeight->"Bold"],
  " maintain an archival copy of the Software on off-line storage media (such \
as diskettes);\n\n",
  StyleBox["c.",
    FontWeight->"Bold"],
  " transfer the license subject to the following conditions: (1) Your Use \
Class permits the transfer of this license; (2) The transferee's use of the \
license falls into the same Use Class, as specified on the License \
Certificate; (3) You notify WRI in writing of Your decision to transfer this \
license and certify that You have destroyed or given to the transferee all \
copies of the Software and other elements of the Product that You have ever \
had; (4) The transferee accepts all the terms and conditions of this \
license."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["PROHIBITED USES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  "All uses of the Software and other elements of the Product not \
specifically allowed in the Permitted Uses section of this License Agreement \
are prohibited. The following is a partial list of prohibited uses of the \
Product. This license does not allow You to:\n\n",
  StyleBox["a. ",
    FontWeight->"Bold"],
  "run more Processes concurrently than the maximum specified on Your License \
Certificate;\n\n",
  StyleBox["b. ",
    FontWeight->"Bold"],
  "run the Software on a computer associated with a Product Class greater \
than the Product Class specified on the License Certificate;\n\n",
  StyleBox["c. ",
    FontWeight->"Bold"],
  "run the Software described in the Product and Binary Kit(s) (if present) \
section(s) of Your License Certificate on a computer of a type other than the \
type(s) of computer(s) described in the Product and Binary Kit(s) (if \
present) section(s);\n\n",
  StyleBox["d. ",
    FontWeight->"Bold"],
  "use the Product in a manner that violates the restrictions associated with \
the Use Class specified on the License Certificate;\n\n",
  StyleBox["e. ",
    FontWeight->"Bold"],
  "use portions of the Software on separate computers (The Software may \
contain multiple executables (e.g., kernel, front end, other programs); \
executables may not be installed or used on separate computers, even if the \
use is not concurrent. In the case of multiple process licenses, the use of \
one or more executables, but not more than one kernel, on a computer is the \
equivalent of the use of a single Process on that computer. In the case of \
Network Licenses, the use of a front end executable that is linked to an \
active kernel on a second computer is counted as a single Process.);\n\n",
  StyleBox["f. ",
    FontWeight->"Bold"],
  "decompile or reverse engineer the Software;\n\n",
  StyleBox["g. ",
    FontWeight->"Bold"],
  "modify the Software in any manner, except those portions written in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and included as standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages;\n\n",
  StyleBox["h. ",
    FontWeight->"Bold"],
  "sublicense, lend, lease or rent the Software or any portion of the \
Software;\n\n",
  StyleBox["i. ",
    FontWeight->"Bold"],
  "copy or allow copying of the Software and other elements of the Product, \
except as permitted for the maintenance of an archival copy of the Software."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["MULTIPLE NETWORK LICENSES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
If this is a Network License, when at least one Process associated \
with this license is not being used, another Network License of the same or \
lesser Product Class and of the same or lesser version number (the version \
number is specified in the Product section of the License Certificate), and \
which is installed on the same computer as this license, may be used as \
though the number of Processes associated with the latter license was \
increased by the number of unused Processes associated with this license. If \
this is done, the Processes may not be used with this license until the other \
license ceases to use them. To use this feature You must follow the \
instructions provided with both this Product and the other Network License \
Product.\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["LIMITED WARRANTY", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
WRI warrants that the Product shall be free from defects in the \
physical media for a period of ninety days following date of purchase when \
used under normal conditions. THE FOREGOING WARRANTY IS IN LIEU OF ALL OTHER \
WARRANTIES, EXPRESS OR IMPLIED. WRI DOES NOT WARRANT THAT THE SOFTWARE IS \
FREE FROM ALL BUGS AND OMISSIONS; THE PRODUCT IS SOLD AS IS. WRI MAKES NO \
REPRESENTATIONS, EXPRESS OR IMPLIED, WITH RESPECT TO THE PRODUCT OR THE \
SOFTWARE CONTAINED IN THE PRODUCT, INCLUDING WITHOUT LIMITATIONS, ANY IMPLIED \
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, ALL OF \
WHICH IS EXPRESSLY DISCLAIMED. WRI DOES NOT WARRANT THAT THE FUNCTIONS \
CONTAINED IN THE PROGRAM WILL MEET YOUR REQUIREMENTS OR THAT THE OPERATION OF \
THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.

IN ADDITION TO THE FOREGOING, YOU SHOULD RECOGNIZE THAT ALL COMPLEX SOFTWARE \
SYSTEMS AND THEIR DOCUMENTATION CONTAIN ERRORS AND OMISSIONS. WRI, ITS \
DISTRIBUTORS AND DEALERS SHALL NOT BE RESPONSIBLE UNDER ANY CIRCUMSTANCES FOR \
PROVIDING INFORMATION ON OR CORRECTIONS TO ERRORS AND OMISSIONS DISCOVERED AT \
ANY TIME IN THE PRODUCT, WHETHER OR NOT THEY ARE AWARE OF THE ERRORS OR \
OMISSIONS. WRI DOES NOT RECOMMEND THE USE OF THE SOFTWARE FOR APPLICATIONS IN \
WHICH ERRORS OR OMISSIONS COULD THREATEN LIFE, INJURY OR SIGNIFICANT LOSS.

SOME STATES DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO THIS MAY NOT \
APPLY TO YOU. THIS WARRANTY GIVES YOU SPECIFIC LEGAL RIGHTS, AND YOU MAY ALSO \
HAVE OTHER RIGHTS WHICH VARY FROM STATE TO STATE. This License Agreement \
shall be construed under the laws of the State of Illinois.\
\>", 
  "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["LIMITED DAMAGES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
IN NO EVENT SHALL WRI, ITS DISTRIBUTORS AND DEALERS BE LIABLE FOR \
ANY LOST PROFITS, LOST BENEFITS, OR ANY CONSEQUENTIAL, INDIRECT, INCIDENTAL, \
SPECIAL OR PUNITIVE DAMAGES, WHETHER IN CONTRACT OR IN TORT, EVEN IF WRI HAS \
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. DIRECT DAMAGES ARE LIMITED \
TO THE AMOUNT OF THE PURCHASE PRICE PAID FOR THE PRODUCT. Some states do not \
allow certain limitations of damages, so the above limitations may not apply \
to you. 
\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["UNITED STATES FEDERAL GOVERNMENT RESTRICTED RIGHTS", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
If this Software is acquired by or on behalf of the U.S. Federal \
government, this provision applies. Use, duplication or disclosure of this \
Software is subject to restrictions set forth in FAR 52.227-19 and DFAR \
252.227-7013, as applicable. The Software is \"commercial computer software\" \
and is licensed with only \"Restricted Rights.\" \
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
Editable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{371, 377},
WindowMargins->{{68, Automatic}, {Automatic, 12}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowFrameElements->"CloseBox",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellBracket->False,
CellMargins->{{0, 10}, {0, 0}},
ShowCellTags->False,
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
    "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    ScriptMinSize->12,
    FontSize->18],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{4, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    ScriptMinSize->8,
    FontSize->10],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["General Styles", "Section"],
  
  Cell[StyleData["SectionHeading"],
    CellMargins->{{10, 10}, {30, 4}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ButtonBar"],
    CellMargins->{{5, 5}, {10, 10}},
    Active->True,
    TextAlignment->Center,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ {
          FrontEnd`ButtonNotebook[ ], #2}]}]&)},
    GridBoxOptions->{RowSpacings->0,
    ColumnSpacings->0,
    GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]}],
  
  Cell[StyleData["PrintButton"],
    CellMargins->{{5, 5}, {10, 10}},
    Active->True,
    FontFamily->"Helvetica",
    FontSize->10,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ {
          FrontEnd`ButtonNotebook[ ], #2}], 
        FrontEndToken[ 
          FrontEnd`ButtonNotebook[ ], "SelectionOpenAllGroups"], 
        FrontEnd`NotebookPrint[ 
          FrontEnd`NotebookSelection[ 
            FrontEnd`ButtonNotebook[ ]], Interactive -> True]}]&)}],
  
  Cell[StyleData["RedRule"],
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->False,
    FontSize->4,
    Background->RGBColor[0.95201, 0.0914931, 0.141176]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Top Matter", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopMatter"],
    CellFrameMargins->{{8, 8}, {5, 5}},
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->GrayLevel[0]],
  
  Cell[StyleData["TopMatter", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["TopMatter", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Contact Information", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContactHeading"],
    CellFrame->True,
    CellMargins->{{10, 10}, {0, 10}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->GrayLevel[0]],
  
  Cell[StyleData["ContactHeading", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContactHeading", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContactText"],
    CellFrame->True,
    CellMargins->{{10, 10}, {10, 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.760876]],
  
  Cell[StyleData["ContactText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContactText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Credits", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CreditsText"],
    CellMargins->{{43, 10}, {4, 4}},
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["CreditsText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CreditsText", "Printout"],
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for License Agreement", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LicenseHeading"],
    CellFrame->True,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 10}, {-1, 5}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    Background->RGBColor[0.897353, 0.836332, 0.551919]],
  
  Cell[StyleData["LicenseHeading", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LicenseHeading", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LicenseText"],
    CellFrame->True,
    CellMargins->{{20, 10}, {5, 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    Background->RGBColor[0.98967, 0.57557, 0.83003]],
  
  Cell[StyleData["LicenseText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LicenseText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Top"->{
    Cell[1710, 49, 774, 22, 27, "ButtonBar",
      CellTags->"Top"],
    Cell[2487, 73, 201, 4, 23, "TopMatter",
      CellTags->"Top"],
    Cell[2691, 79, 103435, 1286, 193, 103126, 1276, "GraphicsData", 
    "Bitmap", "Graphics",
      CellTags->"Top"],
    Cell[106129, 1367, 283, 10, 62, "TopMatter",
      CellTags->"Top"],
    Cell[106415, 1379, 489, 12, 111, "TopMatter",
      CellTags->"Top"]},
  "ContactInformation"->{
    Cell[107604, 1415, 79, 1, 54, "SectionHeading",
      CellTags->"ContactInformation"],
    Cell[107708, 1420, 74, 1, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[107785, 1423, 247, 4, 101, "ContactText",
      CellTags->"ContactInformation"],
    Cell[108069, 1432, 146, 5, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[108218, 1439, 416, 11, 161, "ContactText",
      CellTags->"ContactInformation"],
    Cell[108671, 1455, 136, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[108810, 1460, 545, 14, 191, "ContactText",
      CellTags->"ContactInformation"],
    Cell[109392, 1479, 139, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[109534, 1484, 1070, 36, 356, "ContactText",
      CellTags->"ContactInformation"],
    Cell[110641, 1525, 254, 9, 58, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[110898, 1536, 1219, 40, 311, "ContactText",
      CellTags->"ContactInformation"],
    Cell[112154, 1581, 135, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[112292, 1586, 953, 26, 416, "ContactText",
      CellTags->"ContactInformation"]},
  "Credits"->{
    Cell[113946, 1637, 56, 1, 54, "SectionHeading",
      CellTags->"Credits"],
    Cell[114005, 1640, 5551, 135, 3155, "CreditsText",
      CellTags->"Credits"]},
  "LicenseAgreement"->{
    Cell[120261, 1799, 102, 1, 54, "SectionHeading",
      CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}]},
  "LicenseAgreementPrint"->{
    Cell[120261, 1799, 102, 1, 54, "SectionHeading",
      CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],
    Cell[120388, 1804, 73, 1, 36, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[120464, 1807, 504, 9, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[121005, 1821, 74, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[121082, 1824, 3399, 76, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[124518, 1905, 72, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[124593, 1908, 643, 12, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[125273, 1925, 77, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[125353, 1928, 2147, 36, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[127537, 1969, 78, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[127618, 1972, 2518, 54, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[130173, 2031, 88, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[130264, 2034, 830, 13, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[131131, 2052, 79, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[131213, 2055, 1714, 27, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[132964, 2087, 78, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[133045, 2090, 539, 10, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[133621, 2105, 113, 1, 51, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[133737, 2108, 415, 7, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Top", 140583, 2365},
  {"ContactInformation", 141013, 2377},
  {"Credits", 142218, 2404},
  {"LicenseAgreement", 142406, 2409},
  {"LicenseAgreementPrint", 142553, 2412}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 774, 22, 27, "ButtonBar",
  CellTags->"Top"],
Cell[2487, 73, 201, 4, 23, "TopMatter",
  CellTags->"Top"],
Cell[2691, 79, 103435, 1286, 193, 103126, 1276, "GraphicsData", 
"Bitmap", "Graphics",
  CellTags->"Top"],
Cell[106129, 1367, 283, 10, 62, "TopMatter",
  CellTags->"Top"],
Cell[106415, 1379, 489, 12, 111, "TopMatter",
  CellTags->"Top"],
Cell[106907, 1393, 671, 18, 39, "ButtonBar"],
Cell[107581, 1413, 20, 0, 12, "RedRule"],
Cell[107604, 1415, 79, 1, 54, "SectionHeading",
  CellTags->"ContactInformation"],

Cell[CellGroupData[{
Cell[107708, 1420, 74, 1, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[107785, 1423, 247, 4, 101, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108069, 1432, 146, 5, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[108218, 1439, 416, 11, 161, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108671, 1455, 136, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[108810, 1460, 545, 14, 191, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[109392, 1479, 139, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[109534, 1484, 1070, 36, 356, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110641, 1525, 254, 9, 58, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[110898, 1536, 1219, 40, 311, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112154, 1581, 135, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[112292, 1586, 953, 26, 416, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],
Cell[113260, 1615, 660, 18, 39, "ButtonBar"],
Cell[113923, 1635, 20, 0, 12, "RedRule"],
Cell[113946, 1637, 56, 1, 54, "SectionHeading",
  CellTags->"Credits"],
Cell[114005, 1640, 5551, 135, 3155, "CreditsText",
  CellTags->"Credits"],
Cell[119559, 1777, 676, 18, 39, "ButtonBar"],
Cell[120238, 1797, 20, 0, 12, "RedRule"],
Cell[120261, 1799, 102, 1, 54, "SectionHeading",
  CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],

Cell[CellGroupData[{
Cell[120388, 1804, 73, 1, 36, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[120464, 1807, 504, 9, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[121005, 1821, 74, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[121082, 1824, 3399, 76, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[124518, 1905, 72, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[124593, 1908, 643, 12, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[125273, 1925, 77, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[125353, 1928, 2147, 36, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[127537, 1969, 78, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[127618, 1972, 2518, 54, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[130173, 2031, 88, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[130264, 2034, 830, 13, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[131131, 2052, 79, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[131213, 2055, 1714, 27, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[132964, 2087, 78, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[133045, 2090, 539, 10, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[133621, 2105, 113, 1, 51, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[133737, 2108, 415, 7, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

